/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfjson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.rdfjson.RDFJSONParserSettings;

public class RDFJSONParser
extends AbstractRDFParser {
    private final RDFFormat actualFormat;

    public RDFJSONParser() {
        this(RDFFormat.RDFJSON);
    }

    public RDFJSONParser(RDFFormat actualFormat) {
        this.actualFormat = actualFormat;
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        JsonParser jp = null;
        this.clear();
        try {
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            jp = this.configureNewJsonFactory().createParser(inputStream);
            this.rdfJsonToHandlerInternal(this.rdfHandler, this.valueFactory, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                this.reportFatalError("Found IOException during parsing", e, jp.getCurrentLocation());
            } else {
                this.reportFatalError(e);
            }
        }
        finally {
            this.clear();
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    this.reportFatalError("Found exception while closing JSON parser", e, jp.getCurrentLocation());
                }
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    protected Literal createLiteral(String label, String language, IRI datatype, JsonLocation currentLocation) throws RDFParseException {
        return this.createLiteral(label, language, datatype, currentLocation.getLineNr(), currentLocation.getColumnNr());
    }

    protected void reportError(String msg, Exception e, JsonLocation location, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, e, location.getLineNr(), location.getColumnNr(), setting);
    }

    protected void reportError(String msg, JsonLocation location, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, location.getLineNr(), location.getColumnNr(), setting);
    }

    protected void reportFatalError(String msg, Exception e, JsonLocation location) throws RDFParseException {
        this.reportFatalError(msg, e, location.getLineNr(), location.getColumnNr());
    }

    protected void reportFatalError(String msg, JsonLocation location) throws RDFParseException {
        this.reportFatalError(msg, location.getLineNr(), location.getColumnNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader, String baseUri) throws IOException, RDFParseException, RDFHandlerException {
        JsonParser jp = null;
        this.clear();
        try {
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            jp = this.configureNewJsonFactory().createParser(reader);
            this.rdfJsonToHandlerInternal(this.rdfHandler, this.valueFactory, jp);
        }
        catch (IOException e) {
            if (jp != null) {
                this.reportFatalError("Found IOException during parsing", e, jp.getCurrentLocation());
            } else {
                this.reportFatalError(e);
            }
        }
        finally {
            this.clear();
            if (jp != null) {
                try {
                    jp.close();
                }
                catch (IOException e) {
                    this.reportFatalError("Found exception while closing JSON parser", e, jp.getCurrentLocation());
                }
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    private void rdfJsonToHandlerInternal(RDFHandler handler, ValueFactory vf, JsonParser jp) throws IOException, JsonParseException, RDFParseException, RDFHandlerException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            this.reportFatalError("Expected RDF/JSON document to start with an Object", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            IRI subject;
            String subjStr = jp.getCurrentName();
            Object object = subject = subjStr.startsWith("_:") ? this.createNode(subjStr.substring(2)) : vf.createIRI(subjStr);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                this.reportFatalError("Expected subject value to start with an Object", jp.getCurrentLocation());
            }
            boolean foundPredicate = false;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String predStr = jp.getCurrentName();
                IRI predicate = vf.createIRI(predStr);
                foundPredicate = true;
                if (jp.nextToken() != JsonToken.START_ARRAY) {
                    this.reportFatalError("Expected predicate value to start with an array", jp.getCurrentLocation());
                }
                boolean foundObject = false;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                        this.reportFatalError("Expected object value to start with an Object: subject=<" + subjStr + "> predicate=<" + predStr + ">", jp.getCurrentLocation());
                    }
                    String nextValue = null;
                    String nextType = null;
                    String nextDatatype = null;
                    String nextLanguage = null;
                    HashSet<Object> nextContexts = new HashSet<Object>(2);
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = jp.getCurrentName();
                        if ("value".equals(fieldName)) {
                            if (nextValue != null) {
                                this.reportError("Multiple values found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_VALUES);
                            }
                            jp.nextToken();
                            nextValue = jp.getText();
                            continue;
                        }
                        if ("type".equals(fieldName)) {
                            if (nextType != null) {
                                this.reportError("Multiple types found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_TYPES);
                            }
                            jp.nextToken();
                            nextType = jp.getText();
                            continue;
                        }
                        if ("lang".equals(fieldName)) {
                            if (nextLanguage != null) {
                                this.reportError("Multiple languages found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_LANGUAGES);
                            }
                            jp.nextToken();
                            nextLanguage = jp.getText();
                            continue;
                        }
                        if ("datatype".equals(fieldName)) {
                            if (nextDatatype != null) {
                                this.reportError("Multiple datatypes found for a single object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation(), RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_DATATYPES);
                            }
                            jp.nextToken();
                            nextDatatype = jp.getText();
                            continue;
                        }
                        if ("graphs".equals(fieldName)) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                this.reportError("Expected graphs to start with an array", jp.getCurrentLocation(), RDFJSONParserSettings.SUPPORT_GRAPHS_EXTENSION);
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                String nextGraph = jp.getText();
                                nextContexts.add(nextGraph);
                            }
                            continue;
                        }
                        this.reportError("Unrecognised JSON field name for object: subject=" + subjStr + " predicate=" + predStr + " fieldname=" + fieldName, jp.getCurrentLocation(), RDFJSONParserSettings.FAIL_ON_UNKNOWN_PROPERTY);
                    }
                    Literal object2 = null;
                    if (nextType == null) {
                        this.reportFatalError("No type for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                    }
                    if (nextValue == null) {
                        this.reportFatalError("No value for object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                    }
                    if ("literal".equals(nextType)) {
                        object2 = nextLanguage != null ? this.createLiteral(nextValue, nextLanguage, null, jp.getCurrentLocation()) : (nextDatatype != null ? this.createLiteral(nextValue, null, this.createURI(nextDatatype), jp.getCurrentLocation()) : this.createLiteral(nextValue, null, null, jp.getCurrentLocation()));
                    } else if ("bnode".equals(nextType)) {
                        if (nextLanguage != null) {
                            this.reportFatalError("Language was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        if (nextDatatype != null) {
                            this.reportFatalError("Datatype was attached to a blank node object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        object2 = this.createNode(nextValue.substring(2));
                    } else if ("uri".equals(nextType)) {
                        if (nextLanguage != null) {
                            this.reportFatalError("Language was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        if (nextDatatype != null) {
                            this.reportFatalError("Datatype was attached to a uri object: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
                        }
                        object2 = vf.createIRI(nextValue);
                    }
                    foundObject = true;
                    if (!nextContexts.isEmpty()) {
                        for (String string : nextContexts) {
                            Object context = string.equals("null") ? null : (string.startsWith("_:") ? this.createNode(string.substring(2)) : vf.createIRI(string));
                            Statement st = vf.createStatement((Resource)subject, predicate, (Value)object2, (Resource)context);
                            if (handler == null) continue;
                            handler.handleStatement(st);
                        }
                        continue;
                    }
                    Statement st = vf.createStatement((Resource)subject, predicate, (Value)object2);
                    if (handler == null) continue;
                    handler.handleStatement(st);
                }
                if (foundObject) continue;
                this.reportFatalError("No object for predicate: subject=" + subjStr + " predicate=" + predStr, jp.getCurrentLocation());
            }
            if (foundPredicate) continue;
            this.reportFatalError("No predicate for object: subject=" + subjStr, jp.getCurrentLocation());
        }
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_DATATYPES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_LANGUAGES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_TYPES);
        result.add(RDFJSONParserSettings.FAIL_ON_MULTIPLE_OBJECT_VALUES);
        result.add(RDFJSONParserSettings.FAIL_ON_UNKNOWN_PROPERTY);
        result.add(RDFJSONParserSettings.SUPPORT_GRAPHS_EXTENSION);
        result.add((RioSetting<?>)JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
        result.add((RioSetting<?>)JSONSettings.ALLOW_COMMENTS);
        result.add((RioSetting<?>)JSONSettings.ALLOW_NON_NUMERIC_NUMBERS);
        result.add((RioSetting<?>)JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS);
        result.add((RioSetting<?>)JSONSettings.ALLOW_SINGLE_QUOTES);
        result.add((RioSetting<?>)JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS);
        result.add((RioSetting<?>)JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES);
        result.add((RioSetting<?>)JSONSettings.ALLOW_YAML_COMMENTS);
        result.add((RioSetting<?>)JSONSettings.ALLOW_TRAILING_COMMA);
        result.add((RioSetting<?>)JSONSettings.INCLUDE_SOURCE_IN_LOCATION);
        result.add((RioSetting<?>)JSONSettings.STRICT_DUPLICATE_DETECTION);
        return result;
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactoryBuilder builder = new JsonFactoryBuilder();
        builder.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        builder.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        builder.disable(StreamWriteFeature.AUTO_CLOSE_TARGET);
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            builder.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_COMMENTS)) {
            builder.configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_COMMENTS)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)) {
            builder.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_NON_NUMERIC_NUMBERS)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)) {
            builder.configure(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_SINGLE_QUOTES)) {
            builder.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_SINGLE_QUOTES)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)) {
            builder.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)) {
            builder.configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_YAML_COMMENTS)) {
            builder.configure(JsonReadFeature.ALLOW_YAML_COMMENTS, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_YAML_COMMENTS)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.ALLOW_TRAILING_COMMA)) {
            builder.configure(JsonReadFeature.ALLOW_TRAILING_COMMA, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.ALLOW_TRAILING_COMMA)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.INCLUDE_SOURCE_IN_LOCATION)) {
            builder.configure(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.INCLUDE_SOURCE_IN_LOCATION)).booleanValue());
        }
        if (this.getParserConfig().isSet((RioSetting)JSONSettings.STRICT_DUPLICATE_DETECTION)) {
            builder.configure(StreamReadFeature.STRICT_DUPLICATE_DETECTION, ((Boolean)this.getParserConfig().get((RioSetting)JSONSettings.STRICT_DUPLICATE_DETECTION)).booleanValue());
        }
        return builder.build();
    }
}

