/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.Serializable;

public final class EnumFieldValue
implements Serializable,
Comparable<EnumFieldValue> {
    private final Integer intValue;
    private final String stringValue;

    public int hashCode() {
        int result = this.intValue != null ? this.intValue.hashCode() : 0;
        result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
        return result;
    }

    public EnumFieldValue(Integer intValue, String stringValue) {
        this.intValue = intValue;
        this.stringValue = stringValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumFieldValue)) {
            return false;
        }
        EnumFieldValue otherEnumFieldValue = (EnumFieldValue)obj;
        return this.equalsIntegers(this.intValue, otherEnumFieldValue.intValue) && this.equalStrings(this.stringValue, otherEnumFieldValue.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public Integer toInt() {
        return this.intValue;
    }

    @Override
    public int compareTo(EnumFieldValue o) {
        if (o == null) {
            return 1;
        }
        return this.compareIntegers(this.intValue, o.intValue);
    }

    private boolean equalStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private boolean equalsIntegers(Integer int1, Integer int2) {
        if (int1 == null && int2 == null) {
            return true;
        }
        if (int1 == null) {
            return false;
        }
        if (int2 == null) {
            return false;
        }
        return int1.equals(int2);
    }

    private int compareIntegers(Integer int1, Integer int2) {
        if (int1 == null && int2 == null) {
            return 0;
        }
        if (int1 == null) {
            return -1;
        }
        if (int2 == null) {
            return 1;
        }
        return int1.compareTo(int2);
    }
}

