/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentCache<K, V> {
    private static final int CLEANUP_INTERVAL = 1024;
    private static final float LOAD_FACTOR = 0.75f;
    private final int capacity;
    private volatile int cleanupTick = 0;
    protected final ConcurrentHashMap<K, V> cache;

    public ConcurrentCache(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap((int)((float)capacity / 0.75f), 0.75f);
    }

    public V get(Object key) {
        return this.cache.get(key);
    }

    public V put(K key, V value) {
        this.cleanUp();
        return this.cache.put(key, value);
    }

    public void clear() {
        this.cache.clear();
    }

    protected boolean onEntryRemoval(K key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        ++this.cleanupTick;
        if (this.cleanupTick <= 1024) {
            return;
        }
        this.cleanupTick %= 1024;
        ConcurrentHashMap<K, V> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            int size = this.cache.size();
            if (size < this.capacity + 512) {
                return;
            }
            Iterator iter = ((ConcurrentHashMap.KeySetView)this.cache.keySet()).iterator();
            float removeEachTh = (float)size / (float)(size - this.capacity);
            int i = 0;
            while (iter.hasNext()) {
                Object key = iter.next();
                if ((float)i % removeEachTh < 1.0f) {
                    this.cache.computeIfPresent(key, (k, v) -> this.onEntryRemoval(k) ? null : v);
                }
                ++i;
            }
        }
    }
}

