/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.config;

import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lmdb.LmdbStore;
import org.eclipse.rdf4j.sail.lmdb.config.LmdbStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LmdbStoreFactory
implements SailFactory {
    private static final Logger logger = LoggerFactory.getLogger(LmdbStoreFactory.class);
    public static final String SAIL_TYPE = "rdf4j:LmdbStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new LmdbStoreConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        if (config instanceof LmdbStoreConfig) {
            return new LmdbStore((LmdbStoreConfig)config);
        }
        logger.warn("Config is instance of {} is not LmdbStoreConfig.", (Object)config.getClass().getName());
        return new LmdbStore();
    }
}

