/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.rdf4j.model.NamespaceAware;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Namespaces;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class ContextStatementCollector
extends AbstractRDFHandler {
    private final Collection<Statement> statements;
    private final Map<String, String> namespaces;
    private final Resource[] contexts;
    private final ValueFactory vf;

    public ContextStatementCollector(ValueFactory vf, Resource ... contexts) {
        this(new ArrayList<Statement>(), vf, contexts);
    }

    public ContextStatementCollector(Collection<Statement> statements, ValueFactory vf, Resource ... contexts) {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        this.namespaces = statements instanceof NamespaceAware ? Namespaces.wrap((Set)((NamespaceAware)statements).getNamespaces()) : new LinkedHashMap<String, String>();
        this.statements = statements;
        this.vf = vf;
        this.contexts = contexts;
    }

    public ContextStatementCollector(Collection<Statement> statements, Map<String, String> namespaces, ValueFactory vf, Resource ... contexts) {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        this.statements = statements;
        this.namespaces = namespaces;
        this.vf = vf;
        this.contexts = contexts;
    }

    public void clear() {
        this.statements.clear();
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (!this.namespaces.containsKey(prefix)) {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.contexts.length == 0) {
            this.statements.add(st);
        } else {
            for (Resource nextContext : this.contexts) {
                this.statements.add(this.vf.createStatement(st.getSubject(), st.getPredicate(), st.getObject(), nextContext));
            }
        }
    }
}

