/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailClosable;

abstract class SailClosingIteration<T>
extends IterationWrapper<T> {
    private final SailClosable[] closes;

    public static <E> SailClosingIteration<E> makeClosable(CloseableIteration<? extends E> iter, SailClosable ... closes) {
        return new SailClosingIteration<E>(iter, closes){

            @Override
            protected void handleSailException(SailException e) throws SailException {
                throw e;
            }
        };
    }

    public SailClosingIteration(CloseableIteration<? extends T> iter, SailClosable ... closes) {
        super(iter);
        this.closes = closes;
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        boolean result = super.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public T next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        try {
            return (T)super.next();
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        try {
            super.remove();
        }
        catch (IllegalStateException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() {
        try {
            super.handleClose();
        }
        finally {
            ArrayList<SailException> exceptions = new ArrayList<SailException>();
            ArrayList<Throwable> extraOrdinaryExceptions = new ArrayList<Throwable>();
            for (SailClosable closing : this.closes) {
                try {
                    closing.close();
                }
                catch (SailException e) {
                    exceptions.add(e);
                }
                catch (Throwable e) {
                    extraOrdinaryExceptions.add(e);
                }
            }
            for (SailException nextException : exceptions) {
                this.handleSailException(nextException);
            }
            if (!extraOrdinaryExceptions.isEmpty()) {
                throw new UndeclaredThrowableException((Throwable)extraOrdinaryExceptions.get(0));
            }
        }
    }

    protected abstract void handleSailException(SailException var1);
}

