/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.LongIterator;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\r\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J=\u0010\u001c\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001d2\b\u0010 \u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010#J$\u0010$\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016J\u0013\u0010%\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0011H\u0004J\b\u0010*\u001a\u00020\u0011H\u0004J\b\u0010+\u001a\u00020\u0003H\u0016J+\u0010,\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0004J\b\u00107\u001a\u00020\u0011H\u0016J\b\u00108\u001a\u00020\u0011H\u0002J+\u00109\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001d2\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010;J\u000e\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>J+\u0010?\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001d2\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0002\u00a2\u0006\u0002\u0010@J3\u0010A\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/mapdb/StoreTrivial;", "Lorg/mapdb/Store;", "isThreadSafe", "", "(Z)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "freeRecids", "Lorg/eclipse/collections/impl/stack/mutable/primitive/LongArrayStack;", "isClosed", "()Z", "isReadOnly", "lock", "Ljava/util/concurrent/locks/ReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReadWriteLock;", "maxRecid", "", "records", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "", "clear", "", "clearInternal", "clearInternal$mapdb", "close", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "equals", "other", "", "fileHeaderCheck", "header", "fileHeaderCompose", "fileLoad", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "", "getAllRecids", "Lkotlin/collections/LongIterator;", "loadFrom", "inStream", "Ljava/io/InputStream;", "loadFromInternal", "preallocate", "preallocateInternal", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "saveTo", "outStream", "Ljava/io/OutputStream;", "toByteArray", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)[B", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "verify", "Companion", "mapdb"})
@SourceDebugExtension(value={"SMAP\nStoreTrivial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreTrivial.kt\norg/mapdb/StoreTrivial\n+ 2 Utils.kt\norg/mapdb/Utils\n*L\n1#1,478:1\n88#2,7:479\n78#2,3:486\n99#2,4:489\n78#2,3:493\n104#2,2:496\n88#2,7:498\n88#2,7:505\n88#2,7:512\n88#2,7:519\n88#2,7:526\n99#2,7:533\n88#2,7:540\n99#2,7:547\n99#2,7:554\n*S KotlinDebug\n*F\n+ 1 StoreTrivial.kt\norg/mapdb/StoreTrivial\n*L\n45#1:479,7\n82#1:486,3\n104#1:489,4\n127#1:493,3\n104#1:496,2\n132#1:498,7\n156#1:505,7\n168#1:512,7\n180#1:519,7\n199#1:526,7\n235#1:533,7\n250#1:540,7\n279#1:547,7\n308#1:554,7\n*E\n"})
public class StoreTrivial
implements Store {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isThreadSafe;
    @Nullable
    private final ReadWriteLock lock;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final LongArrayStack freeRecids;
    private volatile long maxRecid;
    @NotNull
    private final LongObjectHashMap<byte[]> records;
    private final boolean isReadOnly;
    @NotNull
    private static final byte[] NULL_RECORD = new byte[0];

    public StoreTrivial(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
        this.lock = Utils.INSTANCE.newReadWriteLock(this.isThreadSafe());
        this.closed = new AtomicBoolean(false);
        this.freeRecids = new LongArrayStack();
        this.records = new LongObjectHashMap();
    }

    public /* synthetic */ StoreTrivial(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @Nullable
    protected final ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadFrom(@NotNull InputStream inStream) {
        Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.loadFromInternal(inStream);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    protected final void loadFromInternal(@NotNull InputStream inStream) {
        long size;
        long recid2;
        Intrinsics.checkNotNullParameter((Object)inStream, (String)"inStream");
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.fileHeaderCheck(new DataInputStream(inStream).readLong());
        long maxRecid2 = 0L;
        this.freeRecids.clear();
        this.records.clear();
        while ((recid2 = DataIO.unpackLong(inStream)) != 0L) {
            maxRecid2 = Math.max(maxRecid2, recid2);
            size = DataIO.unpackLong(inStream) - 1L;
            byte[] data = NULL_RECORD;
            if (size >= 0L) {
                data = new byte[(int)size];
                DataIO.readFully(inStream, data);
            }
            this.records.put(recid2, (Object)data);
        }
        recid2 = 1L;
        size = maxRecid2;
        if (recid2 <= size) {
            while (true) {
                if (!this.records.containsKey(recid2)) {
                    this.freeRecids.push(recid2);
                }
                if (recid2 == size) break;
                ++recid2;
            }
        }
        this.maxRecid = maxRecid2;
        Utils this_$iv = Utils.INSTANCE;
        boolean $i$f$logDebug = false;
        if (this_$iv.getLOG().isLoggable(Level.FINE)) {
            Level level = Level.FINE;
            Logger logger = this_$iv.getLOG();
            boolean bl = false;
            String string = "Loaded " + this.records.size() + " objects";
            logger.log(level, string);
        }
    }

    protected final void fileHeaderCheck(long header) {
        if (header >>> 56 != 74L) {
            throw new DBException.WrongFormat("Wrong file header, not MapDB file");
        }
        if ((header >>> 48 & 0xFFL) != 20L) {
            throw new DBException.WrongFormat("Wrong file header, not StoreTrivial file");
        }
        if ((header >>> 32 & 0xFFFFL) != 0L) {
            throw new DBException.NewMapDBFormat("Store was created with newer format, some new features are not supported");
        }
        if ((header & 0xFFFFFFFFL) != 0L) {
            throw new DBException.NewMapDBFormat("Store was created with newer format, some new features are not supported");
        }
    }

    protected final long fileHeaderCompose() {
        return 5337891458340880384L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveTo(@NotNull OutputStream outStream) {
        Intrinsics.checkNotNullParameter((Object)outStream, (String)"outStream");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            new DataOutputStream(outStream).writeLong(this.fileHeaderCompose());
            MutableLongIterator recidIter = this.records.keySet().longIterator();
            while (recidIter.hasNext()) {
                long recid2 = recidIter.next();
                byte[] bytes = (byte[])this.records.get(recid2);
                DataIO.packLong(outStream, recid2);
                long sizeToWrite = bytes == NULL_RECORD ? -1L : (long)bytes.length;
                DataIO.packLong(outStream, sizeToWrite + 1L);
                if (sizeToWrite < 0L) continue;
                outStream.write(bytes);
            }
            DataIO.packLong(outStream, 0L);
            Utils this_$iv = Utils.INSTANCE;
            boolean $i$f$logDebug = false;
            if (this_$iv.getLOG().isLoggable(Level.FINE)) {
                Level level = Level.FINE;
                Logger logger = this_$iv.getLOG();
                boolean bl2 = false;
                String string = "Saved " + this.records.size() + " records";
                logger.log(level, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            long l = this.preallocateInternal();
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final long preallocateInternal() {
        Utils.INSTANCE.assertWriteLock(this.lock);
        long recid2 = this.freeRecids.isEmpty() ? ++this.maxRecid : this.freeRecids.pop();
        byte[] old = (byte[])this.records.put(recid2, (Object)NULL_RECORD);
        if (old != null) {
            throw new DBException.DataCorruption("Old data were not null");
        }
        return recid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        byte[] bytes = this.toByteArray(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            long recid2 = this.preallocateInternal();
            byte[] old = (byte[])this.records.put(recid2, (Object)bytes);
            if (!Intrinsics.areEqual((Object)old, (Object)NULL_RECORD)) {
                throw new AssertionError((Object)"wrong preallocation");
            }
            long l = recid2;
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        byte[] bytes = this.toByteArray(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.records.get(recid2);
            if (byArray == null) {
                throw new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            byte[] byArray2 = (byte[])this.records.put(recid2, (Object)bytes);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        byte[] expectedOld = this.toByteArray(expectedOldRecord, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.records.get(recid2);
            if (byArray == null) {
                throw new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            if (expectedOldRecord == null && old != NULL_RECORD) {
                boolean bl2 = false;
                return bl2;
            }
            if (!Arrays.equals(expectedOld, old)) {
                boolean bl3 = false;
                return bl3;
            }
            this.records.put(recid2, (Object)this.toByteArray(newRecord, serializer));
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            byte[] byArray = (byte[])this.records.get(recid2);
            if (byArray == null) {
                throw new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            this.records.remove(recid2);
            this.freeRecids.push(recid2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void compact() {
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            byArray = (byte[])this.records.get(recid2);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
        byte[] bytes = byArray;
        if (bytes == null) {
            throw new DBException.GetVoid(recid2);
        }
        if (bytes == NULL_RECORD) {
            return null;
        }
        DataInput2.ByteArray dataIn = new DataInput2.ByteArray(bytes);
        return serializer.deserialize(dataIn, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.clearInternal$mapdb();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final void clearInternal$mapdb() {
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.records.clear();
        this.freeRecids.clear();
        this.maxRecid = 0L;
    }

    private final <R> byte[] toByteArray(R record, Serializer<R> serializer) {
        if (record == null) {
            return NULL_RECORD;
        }
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, record);
        byte[] byArray = out.copyBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyBytes(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StoreTrivial)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            if (this.records.size() != ((StoreTrivial)other).records.size()) {
                boolean bl2 = false;
                return bl2;
            }
            MutableLongIterator recidIter = this.records.keySet().longIterator();
            while (recidIter.hasNext()) {
                byte[] b2;
                long recid2 = recidIter.next();
                byte[] b1 = (byte[])this.records.get(recid2);
                if (b1 == (b2 = (byte[])((StoreTrivial)other).records.get(recid2))) continue;
                if (b1 != b2 && !Arrays.equals(b1, b2)) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (b1 != NULL_RECORD) continue;
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = this.freeRecids.equals((Object)((StoreTrivial)other).freeRecids);
            return bl5;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            LongIterator longIterator = ArrayIteratorsKt.iterator((long[])this.records.keySet().toArray());
            return longIterator;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean fileLoad() {
        return false;
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        return new ArrayList();
    }

    @Override
    public void checkThreadSafe() {
        Store.DefaultImpls.checkThreadSafe(this);
    }

    public StoreTrivial() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/StoreTrivial$Companion;", "", "()V", "NULL_RECORD", "", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

