/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.ArrayBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderComparator
implements Comparator<BindingSet> {
    private static final Logger logger = LoggerFactory.getLogger(OrderComparator.class);
    private final ValueComparator cmp;
    private final Comparator<BindingSet> bindingContentsComparator;

    public OrderComparator(EvaluationStrategy strategy, Order order, ValueComparator cmp, QueryEvaluationContext context) {
        this.cmp = cmp;
        this.bindingContentsComparator = this.precompileComparator(strategy, order, context);
    }

    private Comparator<BindingSet> precompileComparator(EvaluationStrategy strategy, Order order, QueryEvaluationContext context) {
        return order.getElements().stream().map(element -> {
            boolean ascending = element.isAscending();
            ValueExpr expr = element.getExpr();
            if (expr instanceof Var) {
                Function<BindingSet, Value> getValue = context.getValue(((Var)expr).getName());
                return (o1, o2) -> {
                    Value v1 = (Value)getValue.apply((BindingSet)o1);
                    Value v2 = (Value)getValue.apply((BindingSet)o2);
                    int compare = this.cmp.compare(v1, v2);
                    return ascending ? compare : -compare;
                };
            }
            QueryValueEvaluationStep prepared = strategy.precompile(expr, context);
            return (o1, o2) -> {
                Value v1 = null;
                Value v2 = null;
                try {
                    v1 = prepared.evaluate((BindingSet)o1);
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {
                    // empty catch block
                }
                try {
                    v2 = prepared.evaluate((BindingSet)o2);
                }
                catch (ValueExprEvaluationException valueExprEvaluationException) {
                    // empty catch block
                }
                int compare = this.cmp.compare(v1, v2);
                return ascending ? compare : -compare;
            };
        }).reduce(Comparator::thenComparing).orElse((o1, o2) -> 0);
    }

    @Override
    public int compare(BindingSet o1, BindingSet o2) {
        try {
            List<String> o2bindingNamesOrdered;
            List<String> o1bindingNamesOrdered;
            int comparedContents = this.bindingContentsComparator.compare(o1, o2);
            if (comparedContents != 0) {
                return comparedContents;
            }
            if (o1 == null || o2 == null) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                return -1;
            }
            if (o2.size() != o1.size()) {
                return o1.size() < o2.size() ? 1 : -1;
            }
            if (o1 instanceof ArrayBindingSet && o2 instanceof ArrayBindingSet) {
                o1bindingNamesOrdered = ((ArrayBindingSet)o1).getSortedBindingNames();
                o2bindingNamesOrdered = ((ArrayBindingSet)o2).getSortedBindingNames();
            } else {
                o1bindingNamesOrdered = OrderComparator.getSortedBindingNames(o1.getBindingNames());
                o2bindingNamesOrdered = null;
            }
            if (o2bindingNamesOrdered != null && !this.sortedEquals(o1bindingNamesOrdered, o2bindingNamesOrdered) || !o1.getBindingNames().equals(o2.getBindingNames())) {
                if (o2bindingNamesOrdered == null) {
                    o2bindingNamesOrdered = OrderComparator.getSortedBindingNames(o2.getBindingNames());
                }
                for (int i = 0; i < o1bindingNamesOrdered.size(); ++i) {
                    String o2bn;
                    String o1bn = o1bindingNamesOrdered.get(i);
                    int compare = o1bn.compareTo(o2bn = o2bindingNamesOrdered.get(i));
                    if (compare == 0) continue;
                    return compare;
                }
            }
            for (String bindingName : o1bindingNamesOrdered) {
                Value v2;
                Value v1 = o1.getValue(bindingName);
                int compare = this.cmp.compare(v1, v2 = o2.getValue(bindingName));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (IllegalArgumentException | QueryEvaluationException e) {
            logger.debug(e.getMessage(), e);
            return 0;
        }
    }

    private boolean sortedEquals(List<String> o1bindingNamesOrdered, List<String> o2bindingNamesOrdered) {
        if (o1bindingNamesOrdered.size() != o2bindingNamesOrdered.size()) {
            return false;
        }
        for (int i = 0; i < o1bindingNamesOrdered.size(); ++i) {
            if (o1bindingNamesOrdered.get(i).equals(o2bindingNamesOrdered.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<String> getSortedBindingNames(Set<String> bindingNames) {
        if (bindingNames.size() == 1) {
            return Collections.singletonList(bindingNames.iterator().next());
        }
        ArrayList<String> list = new ArrayList<String>(bindingNames);
        Collections.sort(list);
        return list;
    }
}

