/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.mapdb.elsa.ElsaClassCallback;
import org.mapdb.elsa.ElsaClassInfoResolver;
import org.mapdb.elsa.ElsaException;
import org.mapdb.elsa.ElsaSerializerBase;
import org.mapdb.elsa.ElsaStack;
import org.mapdb.elsa.ElsaUtil;
import org.mapdb.elsa.ObjectInputStream2;
import org.mapdb.elsa.ObjectOutputStream2;

public class ElsaSerializerPojo
extends ElsaSerializerBase
implements Serializable {
    private static final Logger LOG;
    protected final ElsaClassCallback missingClassNotification;
    protected final ElsaClassInfoResolver classInfoResolver;
    private static final long serialVersionUID = 1290400014981859025L;
    protected static Method sunConstructor;
    protected static Object sunReflFac;
    protected static Method androidConstructor;
    private static Method androidConstructorGinger;
    private static Method androidConstructorJelly;
    private static Object constructorId;
    protected static Map<Class<?>, Constructor<?>> class2constuctor;

    public ElsaSerializerPojo() {
        this(0, null, null, null, null, null, null);
    }

    public ElsaSerializerPojo(int objectStackType, Object[] singletons, Map<Class, ElsaSerializerBase.Ser> userSer, Map<Class, Integer> userSerHeaders, Map<Integer, ElsaSerializerBase.Deser> userDeser, ElsaClassCallback missingClassNotification, ElsaClassInfoResolver classInfoResolver) {
        super(objectStackType, singletons, userSer, userSerHeaders, userDeser);
        this.missingClassNotification = missingClassNotification != null ? missingClassNotification : ElsaClassCallback.VOID;
        this.classInfoResolver = classInfoResolver != null ? classInfoResolver : ElsaClassInfoResolver.VOID;
    }

    public void classInfoSerialize(DataOutput out, ClassInfo ci) throws IOException {
        out.writeUTF(ci.name);
        out.writeBoolean(ci.isEnum);
        out.writeBoolean(ci.useObjectStream);
        if (ci.useObjectStream) {
            return;
        }
        ElsaUtil.packInt(out, ci.fields.length);
        for (FieldInfo fi : ci.fields) {
            out.writeUTF(fi.name);
            out.writeBoolean(fi.primitive);
            out.writeUTF(fi.type);
        }
    }

    public ClassInfo classInfoDeserialize(DataInput in) throws IOException {
        String className = in.readUTF();
        Class clazz = null;
        boolean isEnum = in.readBoolean();
        boolean isExternalizable = in.readBoolean();
        int fieldsNum = isExternalizable ? 0 : ElsaUtil.unpackInt(in);
        FieldInfo[] fields = new FieldInfo[fieldsNum];
        for (int j = 0; j < fieldsNum; ++j) {
            String fieldName = in.readUTF();
            boolean primitive = in.readBoolean();
            String type = in.readUTF();
            if (clazz == null) {
                clazz = this.loadClass2(className);
            }
            fields[j] = new FieldInfo(fieldName, type, primitive ? null : this.loadClass2(type), clazz);
        }
        return new ClassInfo(className, fields, isEnum, isExternalizable);
    }

    protected static Class classForName(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ElsaException(e);
        }
    }

    protected ClassInfo getClassInfo(int classId) {
        if (classId < 0) {
            return null;
        }
        return this.classInfoResolver.getClassInfo(classId);
    }

    protected void notifyMissingClassInfo(Class className) {
        this.missingClassNotification.classMissing(className);
    }

    public static ClassInfo makeClassInfo(Class clazz) {
        boolean advancedSer = ElsaSerializerPojo.usesAdvancedSerialization(clazz);
        ObjectStreamField[] streamFields = advancedSer ? new ObjectStreamField[]{} : ElsaSerializerPojo.makeFieldsForClass(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            String type = sf.getType().getName();
            fields[i] = new FieldInfo(sf.getName(), type, sf.isPrimitive() ? null : ElsaSerializerPojo.loadClass3(type, Thread.currentThread().getContextClassLoader()), clazz);
        }
        return new ClassInfo(clazz.getName(), fields, clazz.isEnum(), advancedSer);
    }

    public ClassInfo makeClassInfo(String className) {
        Class clazz = this.loadClass2(className);
        boolean advancedSer = ElsaSerializerPojo.usesAdvancedSerialization(clazz);
        ObjectStreamField[] streamFields = advancedSer ? new ObjectStreamField[]{} : ElsaSerializerPojo.makeFieldsForClass(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            String type = sf.getType().getName();
            fields[i] = new FieldInfo(sf.getName(), type, sf.isPrimitive() ? null : this.loadClass2(type), clazz);
        }
        return new ClassInfo(clazz.getName(), fields, clazz.isEnum(), advancedSer);
    }

    protected static boolean usesAdvancedSerialization(Class<?> clazz) {
        if (Externalizable.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            if (clazz.getDeclaredMethod("readObject", ObjectInputStream.class) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (clazz.getDeclaredMethod("writeReplace", new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            if (clazz.getDeclaredMethod("readResolve", new Class[0]) != null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Class<?> su = clazz.getSuperclass();
        if (su == Object.class || su == null) {
            return false;
        }
        return ElsaSerializerPojo.usesAdvancedSerialization(su);
    }

    protected ObjectStreamField[] fieldsForClass(Class<?> clazz) {
        ObjectStreamField[] fields = null;
        ClassInfo classInfo = null;
        int classId = this.classToId(clazz.getName());
        if (classId != -1) {
            classInfo = this.getClassInfo(classId);
            fields = classInfo.getObjectStreamFields();
        }
        if (fields == null) {
            fields = ElsaSerializerPojo.makeFieldsForClass(clazz);
        }
        return fields;
    }

    private static ObjectStreamField[] makeFieldsForClass(Class<?> clazz) {
        ObjectStreamField[] fields = new ObjectStreamField[4];
        int fieldsSize = 0;
        ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
        while (streamClass != null) {
            for (ObjectStreamField f : streamClass.getFields()) {
                if (fieldsSize == fields.length - 1) {
                    fields = Arrays.copyOf(fields, fields.length * 2);
                }
                fields[fieldsSize++] = f;
            }
            streamClass = (clazz = clazz.getSuperclass()) != null ? ObjectStreamClass.lookup(clazz) : null;
        }
        fields = Arrays.copyOf(fields, fieldsSize);
        return fields;
    }

    @Override
    public boolean isSerializable(Object o) {
        if (super.isSerializable(o)) {
            return true;
        }
        return Serializable.class.isAssignableFrom(o.getClass());
    }

    protected void assertClassSerializable(Class<?> clazz) throws NotSerializableException, InvalidClassException {
        if (this.classToId(clazz.getName()) != -1) {
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
    }

    public Object getFieldValue(FieldInfo fieldInfo, Object object) {
        if (fieldInfo.field == null) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.name);
        }
        try {
            return fieldInfo.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get value from field", e);
        }
    }

    public void setFieldValue(FieldInfo fieldInfo, Object object, Object value) {
        if (fieldInfo.field == null) {
            throw new NoSuchFieldError(object.getClass() + "." + fieldInfo.name);
        }
        try {
            fieldInfo.field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not set field value: ", e);
        }
    }

    public int classToId(String className) {
        return this.classInfoResolver.classToId(className);
    }

    @Override
    protected void serializeUnknownObject(DataOutput out, Object obj, ElsaStack objectStack) throws IOException {
        ClassInfo classInfo;
        this.assertClassSerializable(obj.getClass());
        int head = 175;
        int classId = this.classToId(obj.getClass().getName());
        if (classId >= 0) {
            head = 173;
            classInfo = this.getClassInfo(classId);
        } else {
            classId = objectStack.resolveClassId(obj.getClass().getName());
            if (classId < 0) {
                this.notifyMissingClassInfo(obj.getClass());
                classInfo = ElsaSerializerPojo.makeClassInfo(obj.getClass());
                classId = objectStack.addClassInfo(classInfo);
                out.write(176);
                ElsaUtil.packInt(out, classId);
                this.classInfoSerialize(out, classInfo);
            } else {
                classInfo = objectStack.resolveClassInfo(classId);
            }
        }
        out.write(head);
        ElsaUtil.packInt(out, classId);
        if (classInfo.useObjectStream) {
            ObjectOutputStream2 out2 = new ObjectOutputStream2(this, (OutputStream)((Object)out));
            out2.writeObject(obj);
            return;
        }
        if (classInfo.isEnum) {
            int ordinal = ((Enum)obj).ordinal();
            ElsaUtil.packInt(out, ordinal);
        }
        ObjectStreamField[] fields = this.fieldsForClass(obj.getClass());
        ElsaUtil.packInt(out, fields.length);
        for (ObjectStreamField f : fields) {
            int fieldId = classInfo.getFieldId(f.getName());
            if (fieldId == -1) {
                throw new AssertionError((Object)("Missing field: " + f.getName()));
            }
            ElsaUtil.packInt(out, fieldId);
            Object fieldValue = this.getFieldValue(classInfo.fields[fieldId], obj);
            this.serialize(out, fieldValue, objectStack);
        }
    }

    @Override
    protected Object deserializeUnknownHeader(DataInput in, int head, ElsaStack objectStack) throws IOException {
        if (head == 176) {
            ClassInfo classInfo;
            int classId2;
            int classId = ElsaUtil.unpackInt(in);
            if (classId != (classId2 = objectStack.addClassInfo(classInfo = this.classInfoDeserialize(in)))) {
                throw new ElsaException("Wrong Stream ClassInfo order");
            }
            return this.deserialize(in, objectStack);
        }
        if (head != 173 && head != 175) {
            throw new ElsaException("wrong header");
        }
        try {
            Object o;
            ClassInfo classInfo;
            int classId = ElsaUtil.unpackInt(in);
            ClassInfo classInfo2 = classInfo = head == 173 ? this.getClassInfo(classId) : objectStack.resolveClassInfo(classId);
            if (classId == -1 || classInfo.useObjectStream) {
                ObjectInputStream2 in2 = new ObjectInputStream2(this, this.wrapStream(in));
                Object o2 = in2.readObject();
                objectStack.add(o2);
                return o2;
            }
            Class<?> clazz = this.loadClass(classInfo.name);
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new NotSerializableException(clazz.getName());
            }
            if (classInfo.isEnum) {
                int ordinal = ElsaUtil.unpackInt(in);
                o = clazz.getEnumConstants()[ordinal];
            } else {
                o = this.createInstanceSkippinkConstructor(clazz);
            }
            objectStack.add(o);
            int fieldCount = ElsaUtil.unpackInt(in);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldId = ElsaUtil.unpackInt(in);
                FieldInfo f = classInfo.fields[fieldId];
                Object fieldValue = this.deserialize(in, objectStack);
                this.setFieldValue(f, o, fieldValue);
            }
            return o;
        }
        catch (ClassNotFoundException e) {
            throw new ElsaException(e);
        }
    }

    private InputStream wrapStream(DataInput in) {
        if (in instanceof InputStream) {
            return (InputStream)((Object)in);
        }
        return new ElsaUtil.DataInputToStream(in);
    }

    protected <T> T createInstanceSkippinkConstructor(Class<T> clazz) {
        try {
            if (sunConstructor != null) {
                Constructor intConstr = class2constuctor.get(clazz);
                if (intConstr == null) {
                    Constructor objDef = Object.class.getDeclaredConstructor(new Class[0]);
                    intConstr = (Constructor)sunConstructor.invoke(sunReflFac, clazz, objDef);
                    class2constuctor.put(clazz, intConstr);
                }
                return (T)intConstr.newInstance(new Object[0]);
            }
            if (androidConstructor != null) {
                return (T)androidConstructor.invoke(null, clazz, Object.class);
            }
            if (androidConstructorGinger != null) {
                return (T)androidConstructorGinger.invoke(null, clazz, constructorId);
            }
            if (androidConstructorJelly != null) {
                return (T)androidConstructorJelly.invoke(null, clazz, constructorId);
            }
            Constructor<Object> c = class2constuctor.get(clazz);
            if (c == null) {
                c = clazz.getConstructor(new Class[0]);
                if (!c.isAccessible()) {
                    c.setAccessible(true);
                }
                class2constuctor.put(clazz, c);
            }
            return (T)c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method newInstance;
        Method getConstructorId2;
        LOG = Logger.getLogger(ElsaSerializerPojo.class.getName());
        String ver = System.getProperty("java.version");
        if (ver != null && ver.toLowerCase().contains("jrockit")) {
            LOG.warning("Elsa POJO serialization might not work on JRockit JVM. See https://github.com/jankotek/mapdb/issues/572");
        }
        sunConstructor = null;
        sunReflFac = null;
        androidConstructor = null;
        androidConstructorGinger = null;
        androidConstructorJelly = null;
        try {
            Class clazz = ElsaSerializerPojo.loadClass3("sun.reflect.ReflectionFactory", Thread.currentThread().getContextClassLoader());
            if (clazz != null) {
                Method getReflectionFactory = clazz.getMethod("getReflectionFactory", new Class[0]);
                sunReflFac = getReflectionFactory.invoke(null, new Object[0]);
                sunConstructor = clazz.getMethod("newConstructorForSerialization", Class.class, Constructor.class);
            }
        }
        catch (Exception clazz) {
            // empty catch block
        }
        if (sunConstructor == null) {
            try {
                Method newInstance2 = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                newInstance2.setAccessible(true);
                androidConstructor = newInstance2;
            }
            catch (Exception newInstance2) {
                // empty catch block
            }
        }
        if (sunConstructor == null && androidConstructor == null) {
            try {
                getConstructorId2 = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                getConstructorId2.setAccessible(true);
                constructorId = getConstructorId2.invoke(null, Object.class);
                newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, getConstructorId2.getReturnType());
                newInstance.setAccessible(true);
                androidConstructorGinger = newInstance;
            }
            catch (Exception getConstructorId2) {
                // empty catch block
            }
        }
        if (sunConstructor == null && androidConstructor == null && androidConstructorGinger == null) {
            try {
                getConstructorId2 = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                getConstructorId2.setAccessible(true);
                constructorId = getConstructorId2.invoke(null, Object.class);
                newInstance = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Long.TYPE);
                newInstance.setAccessible(true);
                androidConstructorJelly = newInstance;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        class2constuctor = new ConcurrentHashMap();
    }

    public static class FieldInfo {
        public final String name;
        public final boolean primitive;
        public final String type;
        public Class<?> typeClass;
        public final Class<?> clazz;
        public Field field;

        public FieldInfo(String name, String type, Class<?> typeClass, Class<?> clazz) {
            this.name = name;
            this.primitive = typeClass == null;
            this.type = type;
            this.clazz = clazz;
            this.typeClass = typeClass;
            Class<?> aClazz = clazz;
            while (true) {
                if (aClazz == Object.class) {
                    throw new RuntimeException("Could not set field value: " + name + " - " + clazz.toString());
                }
                try {
                    Field f = aClazz.getDeclaredField(name);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    this.field = f;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    aClazz = aClazz.getSuperclass();
                    continue;
                }
                break;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)o;
            if (this.primitive != fieldInfo.primitive) {
                return false;
            }
            if (this.name != null ? !this.name.equals(fieldInfo.name) : fieldInfo.name != null) {
                return false;
            }
            if (this.type != null ? !this.type.equals(fieldInfo.type) : fieldInfo.type != null) {
                return false;
            }
            if (this.typeClass != null ? !this.typeClass.equals(fieldInfo.typeClass) : fieldInfo.typeClass != null) {
                return false;
            }
            if (this.clazz != null ? !this.clazz.equals(fieldInfo.clazz) : fieldInfo.clazz != null) {
                return false;
            }
            return !(this.field == null ? fieldInfo.field != null : !this.field.equals(fieldInfo.field));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.primitive ? 1 : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.typeClass != null ? this.typeClass.hashCode() : 0);
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
            return result;
        }
    }

    public static final class ClassInfo {
        public final String name;
        public final FieldInfo[] fields;
        public final Map<String, FieldInfo> name2fieldInfo = new HashMap<String, FieldInfo>();
        public final Map<String, Integer> name2fieldId = new HashMap<String, Integer>();
        public ObjectStreamField[] objectStreamFields;
        public final boolean isEnum;
        public final boolean useObjectStream;

        public ClassInfo(String name, FieldInfo[] fields, boolean isEnum, boolean isExternalizable) {
            this.name = name;
            this.isEnum = isEnum;
            this.useObjectStream = isExternalizable;
            this.fields = (FieldInfo[])fields.clone();
            for (int i = 0; i < fields.length; ++i) {
                FieldInfo f = fields[i];
                this.name2fieldId.put(f.name, i);
                this.name2fieldInfo.put(f.name, f);
            }
        }

        public int getFieldId(String name) {
            Integer fieldId = this.name2fieldId.get(name);
            if (fieldId != null) {
                return fieldId;
            }
            return -1;
        }

        public ObjectStreamField[] getObjectStreamFields() {
            return this.objectStreamFields;
        }

        public String toString() {
            return super.toString() + "[" + this.name + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassInfo classInfo = (ClassInfo)o;
            if (this.isEnum != classInfo.isEnum) {
                return false;
            }
            if (this.useObjectStream != classInfo.useObjectStream) {
                return false;
            }
            if (this.name != null ? !this.name.equals(classInfo.name) : classInfo.name != null) {
                return false;
            }
            return Arrays.equals(this.fields, classInfo.fields);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.fields != null ? Arrays.hashCode(this.fields) : 0);
            result = 31 * result + (this.isEnum ? 1 : 0);
            result = 31 * result + (this.useObjectStream ? 1 : 0);
            return result;
        }
    }
}

