/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;

public final class IrDebug {
    private static final Set<String> ignore = Set.of("parent", "costEstimate", "totalTimeNanosActual", "cardinality", "cachedHashCode", "isVariableScopeChange", "resultSizeEstimate", "resultSizeActual");

    private IrDebug() {
    }

    public static String dump(IrNode node) {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Var.class, (Object)new VarSerializer()).registerTypeAdapterFactory((TypeAdapterFactory)new OrderedAdapterFactory()).setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return ignore.contains(f.getName());
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }}).create();
        return gson.toJson((Object)node);
    }

    static class VarSerializer
    implements JsonSerializer<Var> {
        VarSerializer() {
        }

        public JsonElement serialize(Var src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString().replace("=", ": "));
        }
    }

    static class OrderedAdapterFactory
    implements TypeAdapterFactory {
        OrderedAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class raw = type.getRawType();
            if (raw.isPrimitive() || Number.class.isAssignableFrom(raw) || CharSequence.class.isAssignableFrom(raw) || Boolean.class.isAssignableFrom(raw) || raw.isEnum() || Collection.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw)) {
                return null;
            }
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    JsonElement tree = delegate.toJsonTree(value);
                    if (tree.isJsonObject()) {
                        JsonObject obj = tree.getAsJsonObject();
                        JsonObject reordered = new JsonObject();
                        obj.entrySet().stream().filter(e -> ((JsonElement)e.getValue()).isJsonPrimitive()).forEach(e -> reordered.add((String)e.getKey(), (JsonElement)e.getValue()));
                        obj.entrySet().stream().filter(e -> ((JsonElement)e.getValue()).isJsonArray()).forEach(e -> reordered.add((String)e.getKey(), (JsonElement)e.getValue()));
                        obj.entrySet().stream().filter(e -> ((JsonElement)e.getValue()).isJsonObject()).forEach(e -> reordered.add((String)e.getKey(), (JsonElement)e.getValue()));
                        Streams.write((JsonElement)reordered, (JsonWriter)out);
                    } else {
                        Streams.write((JsonElement)tree, (JsonWriter)out);
                    }
                }

                public T read(JsonReader in) throws IOException {
                    return delegate.read(in);
                }
            };
        }
    }
}

