/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;

public class Group
extends UnaryTupleOperator {
    private Set<String> groupBindings = Set.of();
    private List<GroupElem> groupElements = new ArrayList<GroupElem>();

    public Group() {
    }

    public Group(TupleExpr arg) {
        super(arg);
    }

    public Group(TupleExpr arg, Iterable<String> groupBindingNames) {
        this(arg);
        this.setGroupBindingNames(groupBindingNames);
    }

    public Group(TupleExpr arg, Iterable<String> groupBindingNames, Iterable<GroupElem> groupElements) {
        this(arg, groupBindingNames);
        this.setGroupElements(groupElements);
    }

    public Set<String> getGroupBindingNames() {
        return this.groupBindings;
    }

    public void addGroupBindingName(String bindingName) {
        if (this.groupBindings.isEmpty()) {
            this.groupBindings = Set.of(bindingName);
            return;
        }
        if (this.groupBindings.size() == 1) {
            this.groupBindings = new LinkedHashSet<String>(this.groupBindings);
        }
        this.groupBindings.add(bindingName);
    }

    public void setGroupBindingNames(List<String> bindingNames) {
        this.groupBindings = bindingNames.isEmpty() ? Set.of() : (bindingNames.size() == 1 ? Set.of(bindingNames.get(0)) : new LinkedHashSet<String>(bindingNames));
    }

    public void setGroupBindingNames(Iterable<String> bindingNames) {
        this.groupBindings = new LinkedHashSet<String>();
        Iterables.addAll(this.groupBindings, bindingNames);
    }

    public List<GroupElem> getGroupElements() {
        return this.groupElements;
    }

    public void addGroupElement(GroupElem groupElem) {
        groupElem.setParentNode(this);
        this.groupElements.add(groupElem);
    }

    public void setGroupElements(Iterable<GroupElem> elements) {
        this.groupElements.clear();
        Iterables.addAll(this.groupElements, elements);
        this.groupElements.forEach(groupElem -> groupElem.setParentNode(this));
    }

    public Set<String> getAggregateBindingNames() {
        LinkedHashSet<String> bindings = new LinkedHashSet<String>();
        for (GroupElem binding : this.groupElements) {
            bindings.add(binding.getName());
        }
        return bindings;
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(this.getGroupBindingNames());
        bindingNames.addAll(this.getAggregateBindingNames());
        return bindingNames;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(this.getGroupBindingNames());
        bindingNames.retainAll(this.getArg().getAssuredBindingNames());
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (GroupElem ge : this.groupElements) {
            ge.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.groupElements, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Group && super.equals(other)) {
            Group o = (Group)other;
            return this.groupBindings.equals(o.getGroupBindingNames()) && this.groupElements.equals(o.getGroupElements());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.groupBindings.hashCode() ^ this.groupElements.hashCode();
    }

    @Override
    public Group clone() {
        Group clone = (Group)super.clone();
        clone.groupBindings = new LinkedHashSet<String>(this.getGroupBindingNames());
        clone.groupElements = new ArrayList<GroupElem>(this.getGroupElements().size());
        for (GroupElem ge : this.getGroupElements()) {
            clone.addGroupElement(ge.clone());
        }
        return clone;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" (");
        Set<String> bindingNames = this.getGroupBindingNames();
        int count = 0;
        for (String name : bindingNames) {
            sb.append(name);
            if (++count >= bindingNames.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

