/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreePackage;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandAllDepthAdapter;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.ExpandDTreeItemRunnableWithProgress;

public class ExpandAllTreeItemsChangeTrigger
implements ModelChangeTrigger {
    public static final NotificationFilter IS_IMPACTING = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return notification.getEventType() == 1 && TreePackage.eINSTANCE.getDTreeItem_Expanded().equals(notification.getFeature());
        }
    };
    private Session session;
    private int expandDepthLimit;

    public ExpandAllTreeItemsChangeTrigger(Session session, int expandDepthLimit) {
        this.session = session;
        this.expandDepthLimit = expandDepthLimit;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        Map<DTreeItem, Integer> dTreeItemsExpandedWithdDepth = this.getDTreeItemsExpandedWithDepth(notifications);
        if (dTreeItemsExpandedWithdDepth.size() > 0) {
            TransactionalEditingDomain domain = this.session.getTransactionalEditingDomain();
            TreeRefreshContext globalContext = new TreeRefreshContext(this.session.getModelAccessor(), this.session.getInterpreter(), this.session.getSemanticResources(), this.session.getTransactionalEditingDomain());
            CompoundCommand expandDTreeItemsCmd = new CompoundCommand(ExpandDTreeItemRunnableWithProgress.getCommandLabel(dTreeItemsExpandedWithdDepth.keySet().iterator().next(), true));
            boolean isAutoRefresh = this.session.getSiriusPreferences().isAutoRefresh();
            dTreeItemsExpandedWithdDepth.forEach((arg_0, arg_1) -> this.lambda$0(expandDTreeItemsCmd, domain, (GlobalContext)globalContext, isAutoRefresh, arg_0, arg_1));
            return Options.newSome((Object)expandDTreeItemsCmd);
        }
        return Options.newNone();
    }

    private void completeCommandWithChildren(DTreeItem parentTreeItem, CompoundCommand expandDTreeItemsCmd, TransactionalEditingDomain domain, GlobalContext globalContext, boolean isAutoRefresh, int currentDepth) {
        if (currentDepth < this.expandDepthLimit) {
            for (DTreeItem dTreeItem : parentTreeItem.getOwnedTreeItems()) {
                if (dTreeItem.isExpanded()) {
                    this.completeCommandWithChildren(dTreeItem, expandDTreeItemsCmd, domain, globalContext, isAutoRefresh, currentDepth + 1);
                    continue;
                }
                expandDTreeItemsCmd.append((Command)ExpandDTreeItemRunnableWithProgress.getExpandCommandForDTreeItem(dTreeItem, domain, globalContext, isAutoRefresh, currentDepth));
            }
        }
    }

    protected Map<DTreeItem, Integer> getDTreeItemsExpandedWithDepth(Collection<Notification> notifications) {
        HashMap<DTreeItem, Integer> result = new HashMap<DTreeItem, Integer>();
        for (Notification notification : notifications) {
            if (!(notification.getNotifier() instanceof DTreeItem)) continue;
            DTreeItem dTreeItem = (DTreeItem)notification.getNotifier();
            result.put(dTreeItem, ExpandAllDepthAdapter.getDepth(dTreeItem));
        }
        return result;
    }

    public int priority() {
        return 0;
    }

    private /* synthetic */ void lambda$0(CompoundCommand compoundCommand, TransactionalEditingDomain transactionalEditingDomain, GlobalContext globalContext, boolean bl, DTreeItem dTreeItemExpanded, Integer depth) {
        this.completeCommandWithChildren(dTreeItemExpanded, compoundCommand, transactionalEditingDomain, globalContext, bl, depth);
    }
}

