/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.sirius.tools.internal.resource.InMemoryResourceFactoryImpl;

public class InMemoryURIHandlerImpl
extends URIHandlerImpl
implements URIHandler {
    public boolean canHandle(URI uri) {
        return "memory".equals(uri.scheme());
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        OutputStream outputStream = null;
        outputStream = "memory".equals(uri.scheme()) ? new ByteArrayOutputStream() : super.createOutputStream(uri, options);
        return outputStream;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        ByteArrayInputStream inputStream = null;
        byte[] buffer = InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.get(uri);
        if (buffer == null || buffer.length == 0) {
            buffer = new byte[1000000];
            InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.put(uri, buffer);
        }
        inputStream = new ByteArrayInputStream(buffer);
        return inputStream;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.containsKey(uri);
    }
}

