/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension.factory;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNCallListener;
import org.eclipse.team.svn.core.connector.ISVNChangeListCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNImportFilterCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNExternalReference;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.connector.configuration.ISVNConfigurationEventHandler;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.StringId;

public class ThreadNameModifier
implements ISVNConnector {
    protected ISVNConnector connector;

    public ThreadNameModifier(ISVNConnector connector) {
        this.connector = connector;
    }

    @Override
    public void addCallListener(ISVNCallListener listener) {
        this.connector.addCallListener(listener);
    }

    @Override
    public void removeCallListener(ISVNCallListener listener) {
        this.connector.removeCallListener(listener);
    }

    @Override
    public void add(String path, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.add(FileUtility.normalizePathJavaHL(path), depth, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void annotate(SVNEntryReference reference, SVNRevisionRange revisionRange, long options, long diffOptions, ISVNAnnotationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.annotate(reference, revisionRange, options, diffOptions, callback, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public long checkout(SVNEntryRevisionReference fromReference, String destPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            long l = this.connector.checkout(ThreadNameModifier.normalizePathJavaHL(fromReference), FileUtility.normalizePathJavaHL(destPath), depth, options, monitor);
            return l;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void cleanup(String path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.cleanup(FileUtility.normalizePathJavaHL(path), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void commit(String[] path, String message, String[] changelistNames, SVNDepth depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.commit(FileUtility.normalizePathsJavaHL(path), this.processSVNLogProperty(message), changelistNames, depth, options, revProps, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void copyLocal(SVNEntryRevisionReference[] srcPaths, String destPath, long options, Map<String, List<SVNExternalReference>> externalsToPin, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.copyLocal(ThreadNameModifier.normalizePathJavaHL(srcPaths), FileUtility.normalizePathJavaHL(destPath), options, externalsToPin, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void copyRemote(SVNEntryRevisionReference[] srcPaths, String destPath, String message, long options, Map revProps, Map<String, List<SVNExternalReference>> externalsToPin, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.copyRemote(ThreadNameModifier.normalizePathJavaHL(srcPaths), FileUtility.normalizePathJavaHL(destPath), this.processSVNLogProperty(message), options, revProps, externalsToPin, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changelistNames, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diffTwo(ThreadNameModifier.normalizePathJavaHL(reference1), ThreadNameModifier.normalizePathJavaHL(reference2), FileUtility.normalizePathJavaHL(relativeToDir), stream, depth, options, changelistNames, outputOptions, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diff(SVNEntryReference reference, SVNRevisionRange revision1, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changelistNames, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diff(ThreadNameModifier.normalizePathJavaHL(reference), revision1, FileUtility.normalizePathJavaHL(relativeToDir), fileName, depth, options, changelistNames, outputOptions, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changelistNames, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diffTwo(ThreadNameModifier.normalizePathJavaHL(reference1), ThreadNameModifier.normalizePathJavaHL(reference2), FileUtility.normalizePathJavaHL(relativeToDir), fileName, depth, options, changelistNames, outputOptions, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diff(SVNEntryReference reference, SVNRevisionRange revision1, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changelistNames, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diff(ThreadNameModifier.normalizePathJavaHL(reference), revision1, FileUtility.normalizePathJavaHL(relativeToDir), stream, depth, options, changelistNames, outputOptions, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diffStatusTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, SVNDepth depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diffStatusTwo(ThreadNameModifier.normalizePathJavaHL(reference1), ThreadNameModifier.normalizePathJavaHL(reference2), depth, options, changelistNames, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void diffStatus(SVNEntryReference reference, SVNRevisionRange revision1, SVNDepth depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.diffStatus(ThreadNameModifier.normalizePathJavaHL(reference), revision1, depth, options, changelistNames, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void dispose() {
        String oldName = this.overrideThreadName();
        try {
            this.connector.dispose();
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public long exportTo(SVNEntryRevisionReference fromReference, String destPath, String nativeEOL, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            long l = this.connector.exportTo(ThreadNameModifier.normalizePathJavaHL(fromReference), FileUtility.normalizePathJavaHL(destPath), nativeEOL, depth, options, monitor);
            return l;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void importTo(String path, String url, String message, SVNDepth depth, long options, Map revProps, ISVNImportFilterCallback filter, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.importTo(FileUtility.normalizePathJavaHL(path), url, this.processSVNLogProperty(message), depth, options, revProps, filter, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public long switchTo(String path, SVNEntryRevisionReference toReference, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            long l = this.connector.switchTo(FileUtility.normalizePathJavaHL(path), ThreadNameModifier.normalizePathJavaHL(toReference), depth, options, monitor);
            return l;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setConfigurationEventHandler(ISVNConfigurationEventHandler configHandler) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setConfigurationEventHandler(configHandler);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public ISVNConfigurationEventHandler getConfigurationEventHandler() throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            ISVNConfigurationEventHandler iSVNConfigurationEventHandler = this.connector.getConfigurationEventHandler();
            return iSVNConfigurationEventHandler;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public String getConfigDirectory() throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            String string = this.connector.getConfigDirectory();
            return string;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public ISVNNotificationCallback getNotificationCallback() {
        String oldName = this.overrideThreadName();
        try {
            ISVNNotificationCallback iSVNNotificationCallback = this.connector.getNotificationCallback();
            return iSVNNotificationCallback;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public ISVNCredentialsPrompt getPrompt() {
        String oldName = this.overrideThreadName();
        try {
            ISVNCredentialsPrompt iSVNCredentialsPrompt = this.connector.getPrompt();
            return iSVNCredentialsPrompt;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void listEntries(SVNEntryRevisionReference reference, SVNDepth depth, int direntFields, long options, ISVNEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.listEntries(ThreadNameModifier.normalizePathJavaHL(reference), depth, direntFields, options, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void lock(String[] path, String comment, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.lock(FileUtility.normalizePathsJavaHL(path), comment, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void listHistoryLog(SVNEntryReference reference, SVNRevisionRange[] revisionRanges, String[] revProps, long limit, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.listHistoryLog(ThreadNameModifier.normalizePathJavaHL(reference), revisionRanges, revProps, limit, options, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void mergeTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.mergeTwo(ThreadNameModifier.normalizePathJavaHL(reference1), ThreadNameModifier.normalizePathJavaHL(reference2), FileUtility.normalizePathJavaHL(localPath), depth, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.merge(ThreadNameModifier.normalizePathJavaHL(reference), revisions, FileUtility.normalizePathJavaHL(localPath), depth, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void mergeReintegrate(SVNEntryReference reference, String localPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.mergeReintegrate(ThreadNameModifier.normalizePathJavaHL(reference), FileUtility.normalizePathJavaHL(localPath), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void mkdir(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.mkdir(FileUtility.normalizePathsJavaHL(path), this.processSVNLogProperty(message), options, revProps, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void moveLocal(String[] srcPaths, String dstPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.moveLocal(FileUtility.normalizePathsJavaHL(srcPaths), FileUtility.normalizePathJavaHL(dstPath), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void moveRemote(String[] srcPaths, String dstPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.moveRemote(FileUtility.normalizePathsJavaHL(srcPaths), FileUtility.normalizePathJavaHL(dstPath), this.processSVNLogProperty(message), options, revProps, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setNotificationCallback(ISVNNotificationCallback notify) {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setNotificationCallback(notify);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setPassword(String password) {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setPassword(password);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public SVNProperty getProperty(SVNEntryRevisionReference reference, String name, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            SVNProperty sVNProperty = this.connector.getProperty(ThreadNameModifier.normalizePathJavaHL(reference), name, changeLists, monitor);
            return sVNProperty;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setPropertyLocal(String[] path, SVNProperty property, SVNDepth depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setPropertyLocal(FileUtility.normalizePathsJavaHL(path), property, depth, options, changelistNames, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setPropertyRemote(SVNEntryReference reference, SVNProperty property, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setPropertyRemote(ThreadNameModifier.normalizePathJavaHL(reference), property, message, options, revProps, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void relocate(String from, String to, String path, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.relocate(from, to, FileUtility.normalizePathJavaHL(path), depth, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void removeLocal(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.removeLocal(FileUtility.normalizePathsJavaHL(path), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void removeRemote(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.removeRemote(FileUtility.normalizePathsJavaHL(path), this.processSVNLogProperty(message), options, revProps, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void resolve(String path, SVNConflictResolution.Choice conflictResult, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.resolve(FileUtility.normalizePathJavaHL(path), conflictResult, depth, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void revert(String[] paths, SVNDepth depth, String[] changeLists, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.revert(FileUtility.normalizePathsJavaHL(paths), depth, changeLists, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setPrompt(ISVNCredentialsPrompt prompt) {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setPrompt(prompt);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void status(String path, SVNDepth depth, long options, String[] changelistNames, ISVNEntryStatusCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.status(FileUtility.normalizePathJavaHL(path), depth, options, changelistNames, callback, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public SVNProperty[] streamFileContent(SVNEntryRevisionReference reference, long options, OutputStream stream, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            SVNProperty[] sVNPropertyArray = this.connector.streamFileContent(ThreadNameModifier.normalizePathJavaHL(reference), options, stream, monitor);
            return sVNPropertyArray;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void unlock(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.unlock(FileUtility.normalizePathsJavaHL(path), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public long[] update(String[] path, SVNRevision revision, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            long[] lArray = this.connector.update(FileUtility.normalizePathsJavaHL(path), revision, depth, options, monitor);
            return lArray;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setUsername(String username) {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setUsername(username);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void addToChangeList(String[] paths, String changelist, SVNDepth depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.addToChangeList(FileUtility.normalizePathsJavaHL(paths), changelist, depth, changelistNames, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void listMergeInfoLog(SVNMergeInfo.LogKind logKind, SVNEntryReference reference, SVNEntryReference mergeSourceReference, SVNRevisionRange mergeSourceRange, String[] revProps, SVNDepth depth, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.listMergeInfoLog(logKind, ThreadNameModifier.normalizePathJavaHL(reference), mergeSourceReference, mergeSourceRange, revProps, depth, options, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void dumpChangeLists(String[] changeLists, String rootPath, SVNDepth depth, ISVNChangeListCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.dumpChangeLists(changeLists, FileUtility.normalizePathJavaHL(rootPath), depth, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public SVNMergeInfo getMergeInfo(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            SVNMergeInfo sVNMergeInfo = this.connector.getMergeInfo(ThreadNameModifier.normalizePathJavaHL(reference), monitor);
            return sVNMergeInfo;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void getInfo(SVNEntryRevisionReference reference, SVNDepth depth, long options, String[] changeLists, ISVNEntryInfoCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.getInfo(ThreadNameModifier.normalizePathJavaHL(reference), depth, options, changeLists, cb, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void listProperties(SVNEntryRevisionReference reference, SVNDepth depth, String[] changelistNames, long options, ISVNPropertyCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.listProperties(ThreadNameModifier.normalizePathJavaHL(reference), depth, changelistNames, options, callback, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void removeFromChangeLists(String[] paths, SVNDepth depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.removeFromChangeLists(FileUtility.normalizePathsJavaHL(paths), depth, changelistNames, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setConfigDirectory(String configDir) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setConfigDirectory(FileUtility.normalizePathJavaHL(configDir));
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setConflictResolver(ISVNConflictResolutionCallback listener) {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setConflictResolver(listener);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public ISVNConflictResolutionCallback getConflictResolver() {
        String oldName = this.overrideThreadName();
        try {
            ISVNConflictResolutionCallback iSVNConflictResolutionCallback = this.connector.getConflictResolver();
            return iSVNConflictResolutionCallback;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public String[] suggestMergeSources(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            String[] stringArray = this.connector.suggestMergeSources(ThreadNameModifier.normalizePathJavaHL(reference), monitor);
            return stringArray;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public SVNProperty[] listRevisionProperties(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            SVNProperty[] sVNPropertyArray = this.connector.listRevisionProperties(ThreadNameModifier.normalizePathJavaHL(reference), monitor);
            return sVNPropertyArray;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public SVNProperty getRevisionProperty(SVNEntryReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            SVNProperty sVNProperty = this.connector.getRevisionProperty(ThreadNameModifier.normalizePathJavaHL(reference), name, monitor);
            return sVNProperty;
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void setRevisionProperty(SVNEntryReference reference, SVNProperty property, String originalValue, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.setRevisionProperty(ThreadNameModifier.normalizePathJavaHL(reference), property, originalValue, options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void upgrade(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.upgrade(FileUtility.normalizePathJavaHL(path), monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void vacuum(String path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.vacuum(FileUtility.normalizePathJavaHL(path), options, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    @Override
    public void patch(String patchPath, String targetPath, int stripCount, long options, ISVNPatchCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        String oldName = this.overrideThreadName();
        try {
            this.connector.patch(FileUtility.normalizePathJavaHL(patchPath), FileUtility.normalizePathJavaHL(targetPath), stripCount, options, callback, monitor);
        }
        finally {
            this.restoreThreadName(oldName);
        }
    }

    protected String overrideThreadName() {
        Thread current = Thread.currentThread();
        String oldName = current.getName();
        current.setName(StringId.generateRandom("SVN", 5));
        return oldName;
    }

    protected void restoreThreadName(String oldName) {
        Thread.currentThread().setName(oldName);
    }

    protected String processSVNLogProperty(String str) {
        return str != null ? str.replaceAll("\r\n|\r", "\n") : null;
    }

    protected static SVNEntryReference normalizePathJavaHL(SVNEntryReference reference) {
        if (reference instanceof SVNEntryRevisionReference) {
            return ThreadNameModifier.normalizePathJavaHL((SVNEntryRevisionReference)reference);
        }
        if (reference instanceof SVNExternalReference) {
            return ThreadNameModifier.normalizePathJavaHL((SVNExternalReference)reference);
        }
        if (reference.path.indexOf("://") == -1) {
            return new SVNEntryReference(FileUtility.normalizePathJavaHL(reference.path), reference.pegRevision);
        }
        return reference;
    }

    protected static SVNExternalReference normalizePathJavaHL(SVNExternalReference reference) {
        if (reference.path.indexOf("://") == -1) {
            return new SVNExternalReference(reference.target, FileUtility.normalizePathJavaHL(reference.path), reference.pegRevision, reference.revision);
        }
        return reference;
    }

    protected static SVNEntryRevisionReference[] normalizePathJavaHL(SVNEntryRevisionReference[] references) {
        SVNEntryRevisionReference[] retVal = new SVNEntryRevisionReference[references.length];
        int i = 0;
        while (i < references.length) {
            retVal[i] = ThreadNameModifier.normalizePathJavaHL(references[i]);
            ++i;
        }
        return retVal;
    }

    protected static SVNEntryRevisionReference normalizePathJavaHL(SVNEntryRevisionReference reference) {
        if (reference.path.indexOf("://") == -1) {
            return new SVNEntryRevisionReference(FileUtility.normalizePathJavaHL(reference.path), reference.pegRevision, reference.revision);
        }
        return reference;
    }
}

