/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetMultiPropertiesOperation
extends AbstractActionOperation
implements IResourceProvider,
IPropertyProvider {
    protected IResource[] resources;
    protected HashMap<IResource, SVNProperty[]> properties;
    protected String propertyName;
    protected int depth;
    protected IStateFilter filter;

    public GetMultiPropertiesOperation(IResource[] resources, int depth, IStateFilter filter, String propertyName) {
        super("Operation_GetMultiProperties", SVNMessages.class);
        this.resources = resources;
        this.propertyName = propertyName;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
        this.properties = new HashMap();
        this.depth = depth;
    }

    @Override
    public IResource[] getResources() {
        Set<IResource> resources = this.properties.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    @Override
    public SVNProperty[] getProperties(IResource resource) {
        return this.properties.get(resource);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.resources.length && !monitor.isCanceled()) {
            IResource current = this.resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                this.protectStep(monitor1 -> FileUtility.visitNodes(current, resource -> {
                    if (monitor1.isCanceled() || FileUtility.isNotSupervised(resource)) {
                        return false;
                    }
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
                    if (this.filter.accept(local)) {
                        this.processResource(proxy, resource, monitor1);
                    }
                    return this.filter.allowsRecursion(local);
                }, this.depth), monitor, this.resources.length);
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }

    protected void processResource(ISVNConnector proxy, IResource current, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
        this.protectStep(monitor1 -> {
            String wcPath = FileUtility.getWorkingCopyPath(current);
            if (this.propertyName != null) {
                SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(wcPath, null, SVNRevision.WORKING), this.propertyName, null, new SVNProgressMonitor(this, monitor1, null));
                if (data != null) {
                    this.properties.put(current, new SVNProperty[]{data});
                }
            } else {
                SVNProperty[] data = SVNUtility.properties(proxy, new SVNEntryRevisionReference(wcPath, null, SVNRevision.WORKING), 0L, new SVNProgressMonitor(this, monitor1, null));
                if (data != null && data.length != 0) {
                    this.properties.put(current, data);
                }
            }
        }, monitor, 1);
    }
}

