/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BreakLockOperation
extends AbstractRepositoryOperation {
    public BreakLockOperation(IRepositoryResource[] resources) {
        super("Operation_BreakLock", SVNMessages.class, resources);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        Map splittedSet = SVNUtility.splitRepositoryLocations(resources);
        for (Map.Entry entry : splittedSet.entrySet()) {
            IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            List values = (List)entry.getValue();
            String[] paths = SVNUtility.asURLArray(values.toArray(new IRepositoryResource[values.size()]), true);
            this.complexWriteToConsole(() -> {
                this.writeToConsole(0, "svn unlock" + ISVNConnector.Options.asCommandLine(4L));
                int i = 0;
                while (i < paths.length && !monitor.isCanceled()) {
                    this.writeToConsole(0, " \"" + SVNUtility.decodeURL(paths[i]) + "\"");
                    ++i;
                }
                this.writeToConsole(0, " --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            });
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> proxy.unlock(paths, 4L, new SVNProgressMonitor(this, monitor1, null)), monitor, splittedSet.size());
            location.releaseSVNProxy(proxy);
        }
    }
}

