/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.remote.AbstractCopyMoveResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.wizard.copymove.CopyMoveWizard;

public abstract class AbstractCopyMoveAction
extends AbstractRepositoryTeamAction {
    protected String operationId;

    public AbstractCopyMoveAction(String operationId) {
        this.operationId = operationId;
    }

    @Override
    public void runImpl(IAction action) {
        CopyMoveWizard copyMoveWizard = new CopyMoveWizard(this.getSelectedRepositoryResources(), this.operationId.toLowerCase().contains("move"));
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)copyMoveWizard);
        if (dlg.open() == 0) {
            String message = copyMoveWizard.getComment();
            IRepositoryResource[] selected = this.getSelectedRepositoryResources();
            IRepositoryResource destination = copyMoveWizard.getDestination();
            AbstractCopyMoveResourcesOperation moveOp = this.makeCopyOperation(destination, selected, message, copyMoveWizard.getNewName());
            CompositeOperation op = new CompositeOperation(moveOp.getId(), moveOp.getMessagesClass());
            op.add((IActionOperation)moveOp);
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)moveOp, 4L), new IActionOperation[]{moveOp});
            op.add((IActionOperation)this.makeRefreshOperation(destination, selected));
            this.runScheduled((IActionOperation)op);
        }
    }

    protected abstract AbstractCopyMoveResourcesOperation makeCopyOperation(IRepositoryResource var1, IRepositoryResource[] var2, String var3, String var4);

    protected abstract RefreshRemoteResourcesOperation makeRefreshOperation(IRepositoryResource var1, IRepositoryResource[] var2);
}

