/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.remote.RenameResourceOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.remote.RenameResourcePanel;

public class RenameAction
extends AbstractRepositoryTeamAction {
    @Override
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        RenameResourcePanel panel = new RenameResourcePanel(resources[0].getName());
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            RenameResourceOperation mainOp = new RenameResourceOperation(resources[0], panel.getResourceName(), panel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(SVNUtility.getCommonParents((IRepositoryResource[])resources)));
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L), new IActionOperation[]{mainOp});
            this.runScheduled((IActionOperation)op);
        }
    }

    @Override
    public boolean isEnabled() {
        IRepositoryResource[] resources;
        IRepositoryResource[] iRepositoryResourceArray = resources = this.getSelectedRepositoryResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource element = iRepositoryResourceArray[n2];
            IRepositoryLocation location = element.getRepositoryLocation();
            if (element.getUrl().equals(location.getRoot().getUrl()) || element.getSelectedRevision().getKind() != SVNRevision.Kind.HEAD || element instanceof IRepositoryRoot && (((IRepositoryRoot)element).getKind() == 4 || ((IRepositoryRoot)element).getKind() == 0)) {
                return false;
            }
            ++n2;
        }
        return resources.length == 1;
    }
}

