/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.mapping.ResourceModelActionProvider;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.mapping.SVNChangeSetModelProvider;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetComparator;
import org.eclipse.team.svn.ui.mapping.SVNChangeSetContentProvider;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class SVNChangeSetActionProvider
extends ResourceModelActionProvider {
    public static final String CHANGE_SET_GROUP = "svnChangeSetActions";
    private static final String CHANGESET_SORTING_TYPE = "org.eclipse.team.ui.SET_SORTING_TYPE";
    private MenuManager sortChangeSetsMenu;
    private MenuManager addToChangeSetMenu;
    private CreateChangeSetAction createChangeSetAction;
    private EditChangeSetAction editChangeSetAction;
    private RemoveChangeSetAction removeChangeSetAction;
    private MakeDefaultChangeSetAction makeDefaultAction;

    protected void initialize() {
        super.initialize();
        if (this.getChangeSetCapability().supportsCheckedInChangeSets()) {
            this.sortChangeSetsMenu = new MenuManager(TeamUIMessages.ChangeLogModelProvider_0a);
            this.sortChangeSetsMenu.add((IAction)new RefreshSortOrderAction(TeamUIMessages.ChangeLogModelProvider_1a, 2));
            this.sortChangeSetsMenu.add((IAction)new RefreshSortOrderAction(TeamUIMessages.ChangeLogModelProvider_2a, 1));
            this.sortChangeSetsMenu.add((IAction)new RefreshSortOrderAction(TeamUIMessages.ChangeLogModelProvider_3a, 3));
        }
        if (this.getChangeSetCapability().supportsActiveChangeSets()) {
            this.addToChangeSetMenu = new MenuManager(TeamUIMessages.ChangeLogModelProvider_12);
            this.addToChangeSetMenu.setRemoveAllWhenShown(true);
            this.addToChangeSetMenu.addMenuListener(manager -> {
                ChangeSet[] sets = this.getActiveChangeSetManager().getSets();
                Arrays.sort(sets, new SVNChangeSetComparator());
                ISelection selection = this.getContext().getSelection();
                this.createChangeSetAction.selectionChanged(selection);
                this.addToChangeSetMenu.add((IAction)this.createChangeSetAction);
                this.addToChangeSetMenu.add((IContributionItem)new Separator());
                ChangeSet[] changeSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSet set2 = changeSetArray[n2];
                    ActiveChangeSet set = (ActiveChangeSet)set2;
                    AddToChangeSetAction action = new AddToChangeSetAction(this.getSynchronizePageConfiguration(), set, selection);
                    manager.add((IAction)action);
                    ++n2;
                }
                this.addToChangeSetMenu.add((IContributionItem)new Separator());
                this.addToChangeSetMenu.add((IAction)new AddToChangeSetAction(this.getSynchronizePageConfiguration(), null, selection));
            });
            this.createChangeSetAction = new CreateChangeSetAction(this.getSynchronizePageConfiguration());
            this.addToChangeSetMenu.add((IAction)this.createChangeSetAction);
            this.addToChangeSetMenu.add((IContributionItem)new Separator());
            this.editChangeSetAction = new EditChangeSetAction(this.getSynchronizePageConfiguration());
            this.makeDefaultAction = new MakeDefaultChangeSetAction(this.getSynchronizePageConfiguration());
            this.removeChangeSetAction = new RemoveChangeSetAction(this.getSynchronizePageConfiguration());
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.isContentProviderEnabled()) {
            super.fillContextMenu(menu);
            if (this.getChangeSetCapability().enableCheckedInChangeSetsFor(this.getSynchronizePageConfiguration())) {
                this.appendToGroup((IContributionManager)menu, "sort", (IContributionItem)this.sortChangeSetsMenu);
            }
            if (this.getChangeSetCapability().enableActiveChangeSetsFor(this.getSynchronizePageConfiguration())) {
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IContributionItem)this.addToChangeSetMenu);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.editChangeSetAction);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.removeChangeSetAction);
                this.appendToGroup((IContributionManager)menu, CHANGE_SET_GROUP, (IAction)this.makeDefaultAction);
            }
        }
    }

    public void dispose() {
        if (this.addToChangeSetMenu != null) {
            this.addToChangeSetMenu.dispose();
            this.addToChangeSetMenu.removeAll();
        }
        if (this.sortChangeSetsMenu != null) {
            this.sortChangeSetsMenu.dispose();
            this.sortChangeSetsMenu.removeAll();
        }
        super.dispose();
    }

    private boolean appendToGroup(IContributionManager manager, String groupId, IContributionItem item) {
        if (manager == null || item == null) {
            return false;
        }
        IContributionItem group = manager.find(groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), item);
            return true;
        }
        return false;
    }

    private boolean appendToGroup(IContributionManager manager, String groupId, IAction action) {
        if (manager == null || action == null) {
            return false;
        }
        IContributionItem group = manager.find(groupId);
        if (group != null) {
            manager.appendToGroup(group.getId(), action);
            return true;
        }
        return false;
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getSynchronizePageConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)participant;
            return provider.getChangeSetCapability();
        }
        return null;
    }

    protected boolean isContentProviderEnabled() {
        SVNChangeSetContentProvider provider = this.getContentProvider();
        if (provider != null) {
            return provider.isEnabled();
        }
        return false;
    }

    public static int getSortCriteria(ISynchronizePageConfiguration configuration) {
        int sortCriteria = 1;
        if (configuration != null) {
            Object o = configuration.getProperty(CHANGESET_SORTING_TYPE);
            if (o instanceof Integer) {
                sortCriteria = (Integer)o;
            } else {
                try {
                    IDialogSettings pageSettings = configuration.getSite().getPageSettings();
                    if (pageSettings != null) {
                        sortCriteria = pageSettings.getInt(CHANGESET_SORTING_TYPE);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        switch (sortCriteria) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                sortCriteria = 1;
            }
        }
        return sortCriteria;
    }

    public static void setSortCriteria(ISynchronizePageConfiguration configuration, int criteria) {
        configuration.setProperty(CHANGESET_SORTING_TYPE, (Object)criteria);
        IDialogSettings pageSettings = configuration.getSite().getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(CHANGESET_SORTING_TYPE, criteria);
        }
    }

    private SVNChangeSetContentProvider getContentProvider() {
        ITreeContentProvider provider;
        INavigatorContentExtension extension = this.getExtension();
        if (extension != null && (provider = extension.getContentProvider()) instanceof SVNChangeSetContentProvider) {
            return (SVNChangeSetContentProvider)provider;
        }
        return null;
    }

    private INavigatorContentExtension getExtension() {
        INavigatorContentService service = this.getActionSite().getContentService();
        Set set = service.findContentExtensionsByTriggerPoint(this.getModelProvider());
        Iterator iter = set.iterator();
        if (iter.hasNext()) {
            INavigatorContentExtension extension = (INavigatorContentExtension)iter.next();
            return extension;
        }
        return null;
    }

    private Object getModelProvider() {
        return SVNChangeSetModelProvider.getProvider();
    }

    public IDiff[] getLocalChanges(IStructuredSelection selection) {
        if (selection instanceof ITreeSelection) {
            TreePath[] paths = ((ITreeSelection)selection).getPaths();
            ArrayList<IDiff> result = new ArrayList<IDiff>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff[] diffs;
                TreePath path = treePathArray[n2];
                IDiff[] iDiffArray = diffs = this.getLocalChanges(path);
                int n3 = diffs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDiff diff = iDiffArray[n4];
                    result.add(diff);
                    ++n4;
                }
                ++n2;
            }
            return result.toArray(new IDiff[result.size()]);
        }
        return new IDiff[0];
    }

    private IDiff[] getLocalChanges(TreePath path) {
        IResourceDiffTree tree = this.getDiffTree(path);
        if (path.getSegmentCount() == 1 && path.getLastSegment() instanceof IDiffTree) {
            return ((ResourceDiffTree)tree).getDiffs();
        }
        ResourceTraversal[] traversals = this.getTraversals(path.getLastSegment());
        return tree.getDiffs(traversals);
    }

    private IResourceDiffTree getDiffTree(TreePath path) {
        return this.getContentProvider().getDiffTree(path);
    }

    private ResourceTraversal[] getTraversals(Object element) {
        if (element instanceof ChangeSet) {
            ChangeSet set = (ChangeSet)element;
            return new ResourceTraversal[]{new ResourceTraversal(set.getResources(), 0, 0)};
        }
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{project}, 2, 0)};
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{file}, 0, 0)};
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 1, 0)};
            }
            if (this.getLayout().equals("org.eclipse.team.ui.tree_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 2, 0)};
            }
            if (this.getLayout().equals("org.eclipse.team.ui.flay_layout")) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{folder}, 0, 0)};
            }
        }
        return new ResourceTraversal[0];
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context != null) {
            if (this.editChangeSetAction != null) {
                this.editChangeSetAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
            if (this.removeChangeSetAction != null) {
                this.removeChangeSetAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
            if (this.makeDefaultAction != null) {
                this.makeDefaultAction.selectionChanged((IStructuredSelection)this.getContext().getSelection());
            }
        }
    }

    public boolean containsLocalChanges(IStructuredSelection selection) {
        if (selection instanceof ITreeSelection) {
            TreePath[] paths;
            ITreeSelection ts = (ITreeSelection)selection;
            TreePath[] treePathArray = paths = ts.getPaths();
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (this.containsLocalChanges(path)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean containsLocalChanges(TreePath path) {
        IResourceDiffTree tree = this.getDiffTree(path);
        ResourceTraversal[] traversals = this.getTraversals(path.getLastSegment());
        return tree.hasMatchingDiffs(traversals, this.getVisibleLocalChangesFilter());
    }

    private FastDiffFilter getVisibleLocalChangesFilter() {
        return new FastDiffFilter(){

            public boolean select(IDiff diff) {
                IThreeWayDiff twd;
                return diff instanceof IThreeWayDiff && SVNChangeSetActionProvider.this.isVisible(diff) && ((twd = (IThreeWayDiff)diff).getDirection() == 256 || twd.getDirection() == 768);
            }
        };
    }

    protected boolean isVisible(IDiff diff) {
        return ((SynchronizePageConfiguration)this.getSynchronizePageConfiguration()).isVisible(diff);
    }

    protected ActiveChangeSetManager getActiveChangeSetManager() {
        return SVNTeamPlugin.instance().getModelChangeSetManager();
    }

    private String getLayout() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
    }

    private class AddToChangeSetAction
    extends ModelParticipantAction {
        private final ActiveChangeSet set;

        public AddToChangeSetAction(ISynchronizePageConfiguration configuration, ActiveChangeSet set, ISelection selection) {
            super(set == null ? TeamUIMessages.ChangeSetActionGroup_2 : set.getTitle(), configuration);
            this.set = set;
            this.selectionChanged(selection);
        }

        public void run() {
            IDiff[] diffArray = SVNChangeSetActionProvider.this.getLocalChanges(this.getStructuredSelection());
            if (this.set != null) {
                this.set.add(diffArray);
            } else {
                ChangeSet[] sets = SVNChangeSetActionProvider.this.getActiveChangeSetManager().getSets();
                IResource[] resources = this.getResources(diffArray);
                ChangeSet[] changeSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSet set2 = changeSetArray[n2];
                    ActiveChangeSet activeSet = (ActiveChangeSet)set2;
                    activeSet.remove(resources);
                    ++n2;
                }
            }
        }

        private IResource[] getResources(IDiff[] diffArray) {
            ArrayList<IResource> result = new ArrayList<IResource>();
            IDiff[] iDiffArray = diffArray;
            int n = diffArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff diff = iDiffArray[n2];
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (resource != null) {
                    result.add(resource);
                }
                ++n2;
            }
            return result.toArray(new IResource[result.size()]);
        }

        protected boolean isEnabledForSelection(IStructuredSelection selection) {
            return SVNChangeSetActionProvider.this.isContentProviderEnabled() && SVNChangeSetActionProvider.this.containsLocalChanges(selection);
        }
    }

    private abstract class ChangeSetAction
    extends BaseSelectionListenerAction {
        public ChangeSetAction(String title, ISynchronizePageConfiguration configuration) {
            super(title);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return this.getSelectedSet() != null;
        }

        protected ActiveChangeSet getSelectedSet() {
            ActiveChangeSet activeChangeSet;
            Object first;
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof ActiveChangeSet && (activeChangeSet = (ActiveChangeSet)first).isUserCreated()) {
                return activeChangeSet;
            }
            return null;
        }
    }

    private class CreateChangeSetAction
    extends ModelParticipantAction {
        public CreateChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_0, configuration);
        }

        public void run() {
            IDiff[] diffs = SVNChangeSetActionProvider.this.getLocalChanges(this.getStructuredSelection());
            UIMonitorUtility.getDisplay().syncExec(() -> this.createChangeSet(diffs));
        }

        protected void createChangeSet(IDiff[] diffs) {
            ActiveChangeSet set = SVNChangeSetActionProvider.this.getChangeSetCapability().createChangeSet(this.getConfiguration(), diffs);
            if (set != null) {
                SVNChangeSetActionProvider.this.getActiveChangeSetManager().add((ChangeSet)set);
            }
        }

        protected boolean isEnabledForSelection(IStructuredSelection selection) {
            return SVNChangeSetActionProvider.this.isContentProviderEnabled() && SVNChangeSetActionProvider.this.containsLocalChanges(selection);
        }
    }

    private class EditChangeSetAction
    extends ChangeSetAction {
        public EditChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_6, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            SVNChangeSetActionProvider.this.getChangeSetCapability().editChangeSet(SVNChangeSetActionProvider.this.getSynchronizePageConfiguration(), set);
        }
    }

    private class MakeDefaultChangeSetAction
    extends ChangeSetAction {
        public MakeDefaultChangeSetAction(ISynchronizePageConfiguration configuration) {
            super(TeamUIMessages.ChangeLogModelProvider_9, configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            SVNChangeSetActionProvider.this.getActiveChangeSetManager().makeDefault(set);
        }
    }

    private class RefreshSortOrderAction
    extends Action {
        private int criteria;

        protected RefreshSortOrderAction(String name, int criteria) {
            super(name, 8);
            this.criteria = criteria;
            this.update();
        }

        public void run() {
            int sortCriteria = SVNChangeSetActionProvider.getSortCriteria(SVNChangeSetActionProvider.this.getSynchronizePageConfiguration());
            if (this.isChecked() && sortCriteria != this.criteria) {
                SVNChangeSetActionProvider.setSortCriteria(SVNChangeSetActionProvider.this.getSynchronizePageConfiguration(), this.criteria);
                this.update();
                ((SynchronizePageConfiguration)SVNChangeSetActionProvider.this.getSynchronizePageConfiguration()).getPage().getViewer().refresh();
            }
        }

        public void update() {
            this.setChecked(this.criteria == SVNChangeSetActionProvider.getSortCriteria(SVNChangeSetActionProvider.this.getSynchronizePageConfiguration()));
        }
    }

    private class RemoveChangeSetAction
    extends ChangeSetAction {
        public RemoveChangeSetAction(ISynchronizePageConfiguration configuration) {
            super("Remove Change Set", configuration);
        }

        public void run() {
            ActiveChangeSet set = this.getSelectedSet();
            if (set == null) {
                return;
            }
            if (MessageDialog.openConfirm((Shell)SVNChangeSetActionProvider.this.getSynchronizePageConfiguration().getSite().getShell(), (String)TeamUIMessages.ChangeSetActionGroup_0, (String)BaseMessages.format((String)TeamUIMessages.ChangeSetActionGroup_1, (Object[])new String[]{set.getTitle()}))) {
                SVNChangeSetActionProvider.this.getActiveChangeSetManager().remove((ChangeSet)set);
            }
        }
    }
}

