/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.view.property;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.operation.local.property.SetMultiPropertiesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.view.property.KeywordTableElement;
import org.eclipse.team.svn.ui.panel.view.property.SVNKeywordProperty;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class PropertyKeywordEditPanel
extends AbstractDialogPanel {
    protected CheckboxTableViewer checkboxViewer;
    protected Button setRecursivelyCheckbox;
    protected Button useMaskCheckbox;
    protected Combo maskText;
    protected IResource[] selectedResources;
    protected IResource[] alreadyWithProperties;
    protected IPropertyProvider properties;
    protected boolean recursionEnabled;
    protected boolean setRecursively;
    protected String mask;
    protected boolean useMask;
    protected boolean computeStates;
    protected KeywordTableElement dateElement;
    protected KeywordTableElement revisionElement;
    protected KeywordTableElement lastChangedByElement;
    protected KeywordTableElement headUrlElement;
    protected KeywordTableElement idElement;
    protected KeywordTableElement headerElement;
    protected UserInputHistory maskHistory;

    public PropertyKeywordEditPanel(IResource[] selection, IResourceProvider alreadyWithProperties, IPropertyProvider properties) {
        this.selectedResources = selection;
        this.properties = properties;
        this.alreadyWithProperties = alreadyWithProperties == null ? new IResource[]{} : alreadyWithProperties.getResources();
        this.recursionEnabled = FileUtility.checkForResourcesPresence((IResource[])selection, (IStateFilter)new IStateFilter.AbstractStateFilter(){

            protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                return false;
            }

            protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                return resource instanceof IContainer;
            }
        }, (int)0);
        this.dialogTitle = SVNUIMessages.PropertyKeywordEditPanel_Title;
        this.dialogDescription = SVNUIMessages.PropertyKeywordEditPanel_Description;
        this.defaultMessage = this.alreadyWithProperties.length > 1 ? SVNUIMessages.PropertyKeywordEditPanel_Message_Single : SVNUIMessages.PropertyKeywordEditPanel_Message_Multi;
        this.initializeKeywordElements();
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        GridData data = new GridData(1808);
        this.checkboxViewer.getTable().setLayoutData((Object)data);
        TableLayout tlayout = new TableLayout();
        this.checkboxViewer.getTable().setLayout((Layout)tlayout);
        TableColumn column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNUIMessages.PropertyKeywordEditPanel_Keyword);
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNUIMessages.PropertyKeywordEditPanel_Description1);
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        column = new TableColumn(this.checkboxViewer.getTable(), 16384);
        column.setText(SVNUIMessages.PropertyKeywordEditPanel_Sample);
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        KeywordTableElement[] elements = new KeywordTableElement[]{this.dateElement, this.revisionElement, this.lastChangedByElement, this.headUrlElement, this.idElement, this.headerElement};
        this.checkboxViewer.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        this.checkboxViewer.addCheckStateListener(event -> {
            KeywordTableElement element = (KeywordTableElement)event.getElement();
            if (element.getCurrentState() == 1) {
                element.setCurrentState(0);
            } else if (element.getCurrentState() == 0 && element.getInitialState() == 2) {
                element.setCurrentState(2);
            } else {
                element.setCurrentState(1);
            }
            this.refreshCheckboxState(element);
        });
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                KeywordTableElement keyElement = (KeywordTableElement)element;
                switch (columnIndex) {
                    case 0: {
                        return keyElement.getName();
                    }
                    case 1: {
                        return keyElement.getDescription();
                    }
                    case 2: {
                        return keyElement.getSample();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.checkboxViewer.setInput((Object)elements);
        this.checkboxViewer.getTable().setHeaderVisible(true);
        this.addSelectionButtons(composite);
        if (this.recursionEnabled || this.selectedResources.length > 1) {
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            separator.setVisible(false);
            Composite subComposite = new Composite(composite, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            subComposite.setLayoutData((Object)new GridData(768));
            subComposite.setLayout((Layout)layout);
            Composite maskComposite = new Composite(subComposite, 0);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 2;
            maskComposite.setLayout((Layout)layout);
            maskComposite.setLayoutData((Object)new GridData(768));
            this.useMaskCheckbox = new Button(maskComposite, 32);
            this.useMaskCheckbox.setText(SVNUIMessages.PropertyKeywordEditPanel_UseMask);
            this.maskHistory = new UserInputHistory("keywordsEditPanel");
            this.maskText = new Combo(maskComposite, 2048);
            this.maskText.setItems(this.maskHistory.getHistory());
            if (this.maskText.getItemCount() == 0) {
                this.maskText.setText("*");
            } else {
                this.maskText.select(0);
            }
            Listener maskTextListener = event -> {
                this.checkboxViewer.setAllGrayed(false);
                this.changeMixedElementsToChecked();
            };
            this.maskText.addListener(13, maskTextListener);
            this.maskText.addListener(24, maskTextListener);
            this.attachTo((Control)this.maskText, new AbstractVerifierProxy(new NonEmptyFieldVerifier(SVNUIMessages.PropertyKeywordEditPanel_Mask_Verifier)){

                @Override
                protected boolean isVerificationEnabled(Control input) {
                    return PropertyKeywordEditPanel.this.useMaskCheckbox.getSelection();
                }
            });
            data = new GridData();
            data.widthHint = 170;
            this.maskText.setLayoutData((Object)data);
            this.maskText.setEnabled(false);
            this.useMaskCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyKeywordEditPanel.this.maskText.setEnabled(PropertyKeywordEditPanel.this.useMaskCheckbox.getSelection());
                    PropertyKeywordEditPanel.this.checkboxViewer.setAllGrayed(false);
                    PropertyKeywordEditPanel.this.changeMixedElementsToChecked();
                    PropertyKeywordEditPanel.this.validateContent();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.recursionEnabled) {
                this.setRecursivelyCheckbox = new Button(subComposite, 32);
                this.setRecursivelyCheckbox.setText(SVNUIMessages.PropertyKeywordEditPanel_Recursively);
                this.setRecursivelyCheckbox.setLayoutData((Object)new GridData(896));
                this.setRecursivelyCheckbox.setSelection(true);
                this.setRecursivelyCheckbox.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PropertyKeywordEditPanel.this.checkboxViewer.setAllGrayed(false);
                        PropertyKeywordEditPanel.this.changeMixedElementsToChecked();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
        KeywordTableElement[] keywordTableElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            KeywordTableElement element = keywordTableElementArray[n2];
            this.refreshCheckboxState(element);
            ++n2;
        }
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.setKeysDialogContext";
    }

    public void performKeywordChanges() {
        Object filter = IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES;
        if (this.useMask) {
            filter = new IStateFilter.AbstractStateFilter(){
                private StringMatcher fileNameMatcher;
                {
                    this.fileNameMatcher = new StringMatcher(PropertyKeywordEditPanel.this.mask);
                }

                protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
                    return IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED.allowsRecursion(resource, state, mask);
                }

                protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
                    if (!IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES.accept(resource, state, mask)) {
                        return false;
                    }
                    return this.fileNameMatcher.match(resource.getName());
                }
            };
        }
        IResourceProvider resourceProvider = () -> this.selectedResources;
        IPropertyProvider propertyProvider = resource -> {
            SVNProperty[] retVal;
            SVNProperty[] sVNPropertyArray = retVal = this.properties == null ? null : this.properties.getProperties(resource);
            if (retVal == null) {
                retVal = new SVNProperty[1];
            }
            SVNKeywordProperty keyProperty = new SVNKeywordProperty(retVal[0] == null ? null : retVal[0].value);
            this.configureProperty(keyProperty);
            retVal[0] = new SVNProperty("svn:keywords", keyProperty.toString());
            return retVal;
        };
        CompositeOperation composite = new CompositeOperation("Operation_SetKeywords", SVNUIMessages.class);
        composite.add((IActionOperation)new SetMultiPropertiesOperation(resourceProvider, propertyProvider, filter, this.recursionEnabled && this.setRecursively ? 2 : 1));
        composite.add((IActionOperation)new RefreshResourcesOperation(resourceProvider));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void configureProperty(SVNKeywordProperty keyProperty) {
        keyProperty.setDateEnabled(this.dateElement.getCurrentState() == 0 ? true : (this.dateElement.getCurrentState() == 1 ? false : keyProperty.isDateEnabled()));
        keyProperty.setRevisionEnabled(this.revisionElement.getCurrentState() == 0 ? true : (this.revisionElement.getCurrentState() == 1 ? false : keyProperty.isLastChangedByEnabled()));
        keyProperty.setLastChangedByEnabled(this.lastChangedByElement.getCurrentState() == 0 ? true : (this.lastChangedByElement.getCurrentState() == 1 ? false : keyProperty.isLastChangedByEnabled()));
        keyProperty.setHeadUrlEnabled(this.headUrlElement.getCurrentState() == 0 ? true : (this.headUrlElement.getCurrentState() == 1 ? false : keyProperty.isHeadUrlEnabled()));
        keyProperty.setIdEnabled(this.idElement.getCurrentState() == 0 ? true : (this.idElement.getCurrentState() == 1 ? false : keyProperty.isIdEnabled()));
        keyProperty.setHeaderEnabled(this.headerElement.getCurrentState() == 0 ? true : (this.headerElement.getCurrentState() == 1 ? false : keyProperty.isHeaderEnabled()));
    }

    protected void applyCurrentKeywordValuesOnTableElement(KeywordTableElement tableElement, boolean propertyPresent) {
        tableElement.setInitialState(tableElement.getInitialState() == -1 ? (propertyPresent ? 0 : 1) : (propertyPresent && tableElement.getInitialState() == 1 || !propertyPresent && tableElement.getInitialState() == 0 ? 2 : tableElement.getInitialState()));
        tableElement.setCurrentState(tableElement.getInitialState());
    }

    protected void initializeKeywordElements() {
        this.dateElement = new KeywordTableElement(SVNKeywordProperty.DATE_NAMES[0], SVNKeywordProperty.DATE_DESCR(), "$LastChangedDate: 2006-08-07 15:40:37 +0000 (Mon, 08 Aug 2006) $", -1);
        this.revisionElement = new KeywordTableElement(SVNKeywordProperty.REVISION_NAMES[0], SVNKeywordProperty.REVISION_DESCR(), "$LastChangedRevision: 7206 $", -1);
        this.lastChangedByElement = new KeywordTableElement(SVNKeywordProperty.AUTHOR_NAMES[0], SVNKeywordProperty.AUTHOR_DESCR(), "$LastChangedBy: J.M.Wade $", -1);
        this.headUrlElement = new KeywordTableElement(SVNKeywordProperty.HEAD_URL_NAMES[0], SVNKeywordProperty.HEAD_URL_DESCR(), "$HeadURL: http://svn.eclipse.org/community/Subversive/src/ui/PropertyKeywordEditPanel.java $", -1);
        this.idElement = new KeywordTableElement(SVNKeywordProperty.ID_NAMES[0], SVNKeywordProperty.ID_DESCR(), "$Id: PropertyKeywordEditPanel.java 7206 2006-08-07 15:40:37 J.M.Wade $", -1);
        this.headerElement = new KeywordTableElement(SVNKeywordProperty.HEADER_NAMES[0], SVNKeywordProperty.HEADER_DESCR(), "$Header: http://svn.example.com/repos/trunk/calc.c 148 2006-07-28 21:30:43Z sally $", -1);
        List<IResource> alreadyWithPropertiesList = Arrays.asList(this.alreadyWithProperties);
        IResource[] iResourceArray = this.selectedResources;
        int n = this.selectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            SVNProperty[] data;
            IResource element = iResourceArray[n2];
            SVNKeywordProperty keywordPropertyValue = new SVNKeywordProperty(null);
            if (alreadyWithPropertiesList.contains(element) && this.properties != null && (data = this.properties.getProperties(element)) != null) {
                keywordPropertyValue = new SVNKeywordProperty(data[0].value);
            }
            this.applyCurrentKeywordValuesOnTableElement(this.dateElement, keywordPropertyValue.isDateEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.revisionElement, keywordPropertyValue.isRevisionEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.lastChangedByElement, keywordPropertyValue.isLastChangedByEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.headUrlElement, keywordPropertyValue.isHeadUrlEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.idElement, keywordPropertyValue.isIdEnabled());
            this.applyCurrentKeywordValuesOnTableElement(this.headerElement, keywordPropertyValue.isHeaderEnabled());
            ++n2;
        }
    }

    protected void refreshCheckboxState(KeywordTableElement element) {
        this.checkboxViewer.setChecked((Object)element, element.getCurrentState() == 2 || element.getCurrentState() == 0);
        this.checkboxViewer.setGrayed((Object)element, element.getCurrentState() == 2);
    }

    protected void changeMixedElementsToChecked() {
        Object[] elements;
        Object[] objectArray = elements = this.checkboxViewer.getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            ((KeywordTableElement)element).setCurrentState(0);
            ++n2;
        }
    }

    protected void addSelectionButtons(Composite composite) {
        Composite tComposite = new Composite(composite, 131072);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        gLayout.marginWidth = 0;
        tComposite.setLayout((Layout)gLayout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        tComposite.setData((Object)data);
        Button selectButton = new Button(tComposite, 8);
        selectButton.setText(SVNUIMessages.Button_SelectAll);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(selectButton);
        selectButton.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyKeywordEditPanel.this.refreshKeywordElements(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(tComposite, 8);
        deselectButton.setText(SVNUIMessages.Button_ClearSelection);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(deselectButton);
        deselectButton.setLayoutData((Object)data);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyKeywordEditPanel.this.refreshKeywordElements(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void refreshKeywordElements(boolean selected) {
        int state = selected ? 0 : 1;
        this.dateElement.setCurrentState(state);
        this.revisionElement.setCurrentState(state);
        this.lastChangedByElement.setCurrentState(state);
        this.headUrlElement.setCurrentState(state);
        this.idElement.setCurrentState(state);
        this.headerElement.setCurrentState(state);
        this.checkboxViewer.setAllChecked(selected);
        this.checkboxViewer.setAllGrayed(false);
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        this.useMask = this.useMaskCheckbox == null ? false : this.useMaskCheckbox.getSelection();
        this.mask = this.maskText == null ? "*" : this.maskText.getText().trim();
        boolean bl = this.setRecursively = this.setRecursivelyCheckbox == null ? false : this.setRecursivelyCheckbox.getSelection();
        if (this.useMask) {
            this.maskHistory.addLine(this.maskText.getText());
        }
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(670, -1);
    }
}

