/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SVNTeamPerformancePage
extends AbstractSVNTeamPreferencesPage {
    protected Button computeDeepButton;
    protected Button preciseEnablementsButton;
    protected Button enableCacheButton;
    protected Button enablePersistentSSHConnectionButton;
    protected boolean computeDeep;
    protected boolean preciseEnablements;
    protected boolean enableCache;
    protected boolean enablePersistentSSHConnection;

    @Override
    public void init(IWorkbench workbench) {
        this.setDescription(SVNUIMessages.PerformancePreferencePage_optionsDesc);
    }

    @Override
    protected void saveValues(IPreferenceStore store) {
        SVNTeamPreferences.setDecorationBoolean(store, "compute.deep", this.computeDeep);
        SVNTeamPreferences.setDecorationBoolean(store, "precise.enablements", this.preciseEnablements);
        SVNTeamPreferences.setDecorationBoolean(store, "enable.cache", this.computeDeep | this.enableCache);
        SVNTeamPreferences.setDecorationBoolean(store, "enable.persistent.ssh", this.enablePersistentSSHConnection);
    }

    @Override
    protected void loadDefaultValues(IPreferenceStore store) {
        this.computeDeep = true;
        this.preciseEnablements = false;
        this.enableCache = true;
        this.enablePersistentSSHConnection = true;
    }

    @Override
    protected void loadValues(IPreferenceStore store) {
        this.computeDeep = SVNTeamPreferences.getDecorationBoolean(store, "compute.deep");
        this.preciseEnablements = SVNTeamPreferences.getDecorationBoolean(store, "precise.enablements");
        this.enableCache = SVNTeamPreferences.getDecorationBoolean(store, "enable.cache");
        this.enablePersistentSSHConnection = SVNTeamPreferences.getDecorationBoolean(store, "enable.persistent.ssh");
    }

    @Override
    protected void initializeControls() {
        this.computeDeepButton.setSelection(this.computeDeep);
        this.preciseEnablementsButton.setSelection(this.preciseEnablements);
        this.enableCacheButton.setSelection(this.enableCache);
        this.enablePersistentSSHConnectionButton.setSelection(this.enablePersistentSSHConnection);
        if (this.computeDeep || this.preciseEnablements) {
            this.enableCacheButton.setEnabled(false);
        } else if (!this.enableCache) {
            this.computeDeepButton.setEnabled(false);
            this.preciseEnablementsButton.setEnabled(false);
        }
    }

    @Override
    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        Composite noteComposite = new Composite(composite, 4);
        layout = new GridLayout();
        layout.marginWidth = 0;
        noteComposite.setLayout((Layout)layout);
        noteComposite.setLayoutData((Object)new GridData(768));
        Label separator = new Label(noteComposite, 258);
        data = new GridData(768);
        separator.setLayoutData((Object)data);
        this.computeDeepButton = new Button(composite, 32);
        this.computeDeepButton.setLayoutData((Object)new GridData());
        this.computeDeepButton.setText(SVNUIMessages.PerformancePreferencePage_computeDeep);
        this.computeDeepButton.addListener(13, event -> {
            this.computeDeep = this.computeDeepButton.getSelection();
            this.enableCacheButton.setEnabled(!(this.computeDeep | this.preciseEnablements));
        });
        this.preciseEnablementsButton = new Button(composite, 32);
        this.preciseEnablementsButton.setLayoutData((Object)new GridData());
        this.preciseEnablementsButton.setText(SVNUIMessages.PerformancePreferencePage_preciseEnablements);
        this.preciseEnablementsButton.addListener(13, event -> {
            this.preciseEnablements = this.preciseEnablementsButton.getSelection();
            this.enableCacheButton.setEnabled(!(this.computeDeep | this.preciseEnablements));
        });
        this.enableCacheButton = new Button(composite, 32);
        this.enableCacheButton.setLayoutData((Object)new GridData());
        this.enableCacheButton.setText(SVNUIMessages.PerformancePreferencePage_enableCache);
        this.enableCacheButton.addListener(13, event -> {
            this.enableCache = this.enableCacheButton.getSelection();
            this.computeDeepButton.setEnabled(this.enableCache);
            this.preciseEnablementsButton.setEnabled(this.enableCache);
        });
        this.enablePersistentSSHConnectionButton = new Button(composite, 32);
        this.enablePersistentSSHConnectionButton.setLayoutData((Object)new GridData());
        this.enablePersistentSSHConnectionButton.setText(SVNUIMessages.PerformancePreferencePage_enablePersistentSSHConnection);
        this.enablePersistentSSHConnectionButton.addListener(13, event -> {
            boolean bl = this.enablePersistentSSHConnection = this.enablePersistentSSHConnectionButton.getSelection();
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.performancePreferencesContext");
        return composite;
    }
}

