/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.model;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.history.model.AbstractLogNode;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.utility.DateFormatter;

public class SVNLogNode
extends AbstractLogNode {
    protected SVNLogEntry entry;

    public SVNLogNode(SVNLogEntry entry, ILogNode parent) {
        super(parent);
        this.entry = entry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(SVNLogEntry.class)) {
            return this.entry;
        }
        return null;
    }

    @Override
    public ILogNode[] getChildren() {
        SVNLogEntry[] entries = this.entry.getChildren();
        ILogNode[] children = new ILogNode[entries.length];
        int i = 0;
        while (i < entries.length) {
            children[i] = new SVNLogNode(entries[i], this);
            ++i;
        }
        return children;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return SVNTeamUIPlugin.instance().getImageDescriptor(this.parent instanceof SVNLogNode ? "icons/objects/repository-gray.gif" : "icons/objects/repository.gif");
    }

    @Override
    public boolean requiresBoldFont(long currentRevision) {
        return currentRevision != -1L && this.entry.revision == currentRevision;
    }

    @Override
    public String getLabel(int columnIndex, int labelType, long currentRevision) {
        switch (columnIndex) {
            case 0: {
                Object retVal = String.valueOf(this.entry.revision);
                if (currentRevision == this.entry.revision) {
                    retVal = "*" + (String)retVal;
                }
                return retVal;
            }
            case 1: {
                return this.entry.date == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate(this.entry.date);
            }
            case 2: {
                return String.valueOf(this.entry.changedPaths != null ? this.entry.changedPaths.length : 0);
            }
            case 3: {
                return this.entry.author == null || this.entry.author.length() == 0 ? SVNMessages.SVNInfo_NoAuthor : this.entry.author;
            }
            case 4: {
                String retVal = this.entry.message;
                if (retVal == null || retVal.length() == 0) {
                    return SVNMessages.SVNInfo_NoComment;
                }
                if (labelType == 0) {
                    return FileUtility.formatMultilineText((String)retVal);
                }
                if (labelType == 1) {
                    return AbstractLogNode.flattenMultiLineText(retVal, " ");
                }
                return retVal;
            }
        }
        return "";
    }

    @Override
    public Object getEntity() {
        return this.entry;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean hasChildren() {
        return this.entry.hasChildren();
    }

    @Override
    public String getAuthor() {
        return this.entry.author;
    }

    @Override
    public int getChangesCount() {
        return this.entry.changedPaths == null ? 0 : this.entry.changedPaths.length;
    }

    @Override
    public String getComment() {
        return this.entry.message;
    }

    @Override
    public long getRevision() {
        return this.entry.revision;
    }

    @Override
    public long getTimeStamp() {
        return this.entry.date;
    }

    public int hashCode() {
        return (int)this.entry.revision;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SVNLogNode) {
            return this.entry.revision == ((SVNLogNode)obj).entry.revision;
        }
        return false;
    }
}

