/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.callback;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateFailures;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateInfo;
import org.eclipse.team.svn.core.utility.PatternProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.ArrayStructuredContentProvider;

public class AskTrustSSLServerPanel
extends AbstractDialogPanel {
    protected SSLServerCertificateFailures failures;
    protected SSLServerCertificateInfo info;

    public AskTrustSSLServerPanel(String location, SSLServerCertificateFailures failures, SSLServerCertificateInfo info, boolean allowPermanently) {
        String[] stringArray;
        if (allowPermanently) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = SVNUIMessages.AskTrustSSLServerPanel_Trust;
            stringArray2[1] = SVNUIMessages.AskTrustSSLServerPanel_TrustAlways;
            stringArray = stringArray2;
            stringArray2[2] = IDialogConstants.NO_LABEL;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = IDialogConstants.YES_LABEL;
            stringArray = stringArray3;
            stringArray3[1] = IDialogConstants.NO_LABEL;
        }
        super(stringArray);
        this.dialogTitle = SVNUIMessages.AskTrustSSLServerPanel_Title;
        this.dialogDescription = SVNUIMessages.AskTrustSSLServerPanel_Description;
        this.defaultMessage = BaseMessages.format((String)SVNUIMessages.AskTrustSSLServerPanel_Message, (Object[])new String[]{location});
        this.failures = failures;
        this.info = info;
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(530, 250);
    }

    @Override
    public void createControlsImpl(Composite parent) {
        ArrayList<String[]> tData = new ArrayList<String[]>();
        String[] line = new String[2];
        line[0] = SVNUIMessages.AskTrustSSLServerPanel_Server;
        for (String s : this.info.hostnames) {
            String string = line[1] = line[1] != null ? line[1] + ", " + s : s;
        }
        tData.add(line);
        line = new String[]{SVNUIMessages.AskTrustSSLServerPanel_Problems, ""};
        if (this.failures.anyOf(0x40000008)) {
            line[1] = String.valueOf(line[1]) + SVNUIMessages.AskTrustSSLServerPanel_MsgNotTrusted;
        }
        if (this.failures.anyOf(0x40000004)) {
            line[1] = String.valueOf(line[1]) + (String)(line[1].length() > 0 ? "\n" + SVNUIMessages.AskTrustSSLServerPanel_MsgHostNameDoNotMatch : SVNUIMessages.AskTrustSSLServerPanel_MsgHostNameDoNotMatch);
        }
        if (this.failures.anyOf(0x40000001)) {
            line[1] = String.valueOf(line[1]) + (String)(line[1].length() > 0 ? "\n" + SVNUIMessages.AskTrustSSLServerPanel_MsgNotYetValid : SVNUIMessages.AskTrustSSLServerPanel_MsgNotYetValid);
        }
        if (this.failures.anyOf(0x40000002)) {
            line[1] = String.valueOf(line[1]) + (String)(line[1].length() > 0 ? "\n" + SVNUIMessages.AskTrustSSLServerPanel_MsgExpired : SVNUIMessages.AskTrustSSLServerPanel_MsgExpired);
        }
        tData.add(line);
        line = new String[]{"Subject", this.info.subject};
        tData.add(line);
        line = new String[]{"Valid", SVNUtility.formatSSLValid((Date)this.info.validFrom, (Date)this.info.validTo)};
        tData.add(line);
        line = new String[]{"Issuer", this.info.issuer};
        tData.add(line);
        line = new String[]{"Fingerprint", SVNUtility.formatSSLFingerprint((byte[])this.info.fingerprint)};
        tData.add(line);
        final String[][] tableData = (String[][])tData.toArray((T[])new String[tData.size()][]);
        GridData data = null;
        SashForm innerSashForm = new SashForm(parent, 512);
        data = new GridData(1808);
        innerSashForm.setLayoutData((Object)data);
        final Table table = new Table((Composite)innerSashForm, 68356);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tLayout = new TableLayout();
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, true));
        table.setLayout((Layout)tLayout);
        final Text text = new Text((Composite)innerSashForm, 2818);
        innerSashForm.setWeights(new int[]{25, 75});
        TableColumn col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText(SVNUIMessages.AskTrustSSLServerPanel_Field);
        col = new TableColumn(table, 16384);
        col.setResizable(true);
        col.setText(SVNUIMessages.AskTrustSSLServerPanel_Value);
        TableViewer view = new TableViewer(table);
        view.setContentProvider((IContentProvider)new ArrayStructuredContentProvider());
        view.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String[] row = (String[])element;
                return row[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        view.setInput((Object)tableData);
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = table.getSelectionIndex();
                if (idx > -1 && idx < tableData.length) {
                    text.setText(PatternProvider.replaceAll((String)tableData[idx][1].trim(), (String)", ", (String)"\n"));
                }
            }
        };
        table.addSelectionListener(listener);
        data = new GridData(1808);
        text.setLayoutData((Object)data);
        text.setEditable(false);
        table.setSelection(0);
        listener.widgetSelected(null);
    }

    @Override
    protected void saveChangesImpl() {
    }

    @Override
    protected void cancelChangesImpl() {
    }
}

