/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.discovery.model.Group;
import org.eclipse.team.svn.core.discovery.model.Icon;
import org.eclipse.team.svn.core.discovery.model.Overview;
import org.eclipse.team.svn.core.discovery.model.ValidationException;

public class ConnectorCategory {
    protected String id;
    protected String name;
    protected String description;
    protected String relevance;
    protected Icon icon;
    protected Overview overview;
    protected List<Group> group = new ArrayList<Group>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelevance() {
        return this.relevance;
    }

    public void setRelevance(String relevance) {
        this.relevance = relevance;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public void setOverview(Overview overview) {
        this.overview = overview;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    public void setGroup(List<Group> group) {
        this.group = group;
    }

    public void validate() throws ValidationException {
        if (this.id == null || this.id.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorCategory_must_specify_connectorCategory_id);
        }
        if (this.name == null || this.name.length() == 0) {
            throw new ValidationException(SVNMessages.ConnectorCategory_must_specify_connectorCategory_name);
        }
        if (this.icon != null) {
            this.icon.validate();
        }
        if (this.relevance != null) {
            try {
                int r = Integer.parseInt(this.relevance, 10);
                if (r < 0 || r > 100) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidationException(SVNMessages.ConnectorCategory_connectorCategory_relevance_invalid);
            }
        }
        if (this.overview != null) {
            this.overview.validate();
        }
        for (Group groupItem : this.group) {
            groupItem.validate();
        }
    }
}

