/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IConsoleStream;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNProgressMonitor
extends SVNNullProgressMonitor {
    protected IProgressMonitor monitor;
    protected IActionOperation parent;
    protected IConsoleStream stream;
    protected IPath root;
    protected boolean enableConsoleOutput;

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
        this(parent, monitor, root, true);
    }

    public SVNProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root, boolean enableConsoleOutput) {
        this.monitor = monitor;
        this.parent = parent;
        this.root = root;
        this.stream = parent.getConsoleStream();
        this.enableConsoleOutput = enableConsoleOutput;
    }

    @Override
    public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
        if (state.error != null) {
            SVNConnectorException ex = state.path != null && state.path.length() > 0 ? new SVNConnectorUnresolvedConflictException(state.error) : new SVNConnectorException(state.error);
            this.parent.reportStatus(4, null, ex);
        }
        if (state != null && state.path != null) {
            ProgressMonitorUtility.setTaskInfo(this.monitor, this.parent, state.path);
            if (this.enableConsoleOutput) {
                SVNProgressMonitor.writeToConsole(this.stream, state.contentState, state.propState, state.action, state.path, state.revision);
            }
        }
        ProgressMonitorUtility.progress(this.monitor, current, total);
    }

    @Override
    public boolean isActivityCancelled() {
        return this.monitor.isCanceled();
    }

    public static void writeToConsole(IConsoleStream stream, int contentState, int propState, int action, String path, long revision) {
        if (stream != null && path != null && path.length() > 0) {
            SVNNotification.PerformedAction pAction = SVNNotification.PerformedAction.fromId(action);
            if (pAction == SVNNotification.PerformedAction.UPDATE_COMPLETED || pAction == SVNNotification.PerformedAction.STATUS_COMPLETED) {
                String message = BaseMessages.format(SVNMessages.Console_AtRevision, new String[]{String.valueOf(revision)});
                stream.write(1, message);
            } else if (pAction == SVNNotification.PerformedAction.UPDATE_EXTERNAL) {
                String message = BaseMessages.format(SVNMessages.Console_UpdateExternal, new String[]{path});
                stream.write(1, message);
            } else {
                int severity = 1;
                String status = null;
                switch (pAction) {
                    case ADD: 
                    case UPDATE_ADD: 
                    case COMMIT_ADDED: {
                        status = SVNMessages.Console_Action_Added;
                        break;
                    }
                    case DELETE: 
                    case UPDATE_DELETE: 
                    case COMMIT_DELETED: {
                        status = SVNMessages.Console_Action_Deleted;
                        break;
                    }
                    case UPDATE_UPDATE: {
                        int resourceState = contentState == SVNNotification.NodeStatus.INAPPLICABLE.id || contentState == SVNNotification.NodeStatus.UNCHANGED.id ? propState : contentState;
                        int n = severity = contentState == SVNNotification.NodeStatus.CONFLICTED.id || contentState == SVNNotification.NodeStatus.OBSTRUCTED.id || propState == SVNNotification.NodeStatus.CONFLICTED.id ? 2 : 1;
                        if (resourceState >= 0 && resourceState < SVNNotification.NodeStatus.shortStatusNames.length && (status = SVNMessages.getString("Console_Update_Status_" + SVNNotification.NodeStatus.statusNames[resourceState])).length() > 0) break;
                        status = " ";
                        break;
                    }
                    case COMMIT_MODIFIED: {
                        status = SVNMessages.Console_Action_Modified;
                        break;
                    }
                    case COMMIT_REPLACED: {
                        status = SVNMessages.Console_Action_Replaced;
                        break;
                    }
                    case REVERT: {
                        status = SVNMessages.Console_Action_Reverted;
                        break;
                    }
                    case RESTORE: {
                        status = SVNMessages.Console_Action_Restored;
                        break;
                    }
                    case LOCKED: {
                        status = SVNMessages.Console_Action_Locked;
                        break;
                    }
                    case UNLOCKED: {
                        status = SVNMessages.Console_Action_Unlocked;
                        break;
                    }
                    case TREE_CONFLICT: {
                        status = SVNMessages.Console_Status_Conflicted;
                        severity = 2;
                        break;
                    }
                    default: {
                        int resourceState = contentState == SVNEntryStatus.Kind.NORMAL.id ? propState : contentState;
                        status = SVNProgressMonitor.getStatus(resourceState);
                        int n = severity = resourceState == SVNEntryStatus.Kind.CONFLICTED.id || resourceState == SVNEntryStatus.Kind.OBSTRUCTED.id ? 2 : 1;
                    }
                }
                if (pAction == SVNNotification.PerformedAction.COMMIT_POSTFIX_TXDELTA) {
                    String message = BaseMessages.format(SVNMessages.Console_TransmittingData, new String[]{path});
                    stream.write(severity, message);
                } else if (status != null) {
                    String message = BaseMessages.format(SVNMessages.Console_Status, new String[]{status, path});
                    stream.write(severity, message);
                }
            }
        }
    }

    protected static String getStatus(int resourceState) {
        switch (SVNEntryStatus.Kind.fromId(resourceState)) {
            case ADDED: {
                return SVNMessages.Console_Status_Added;
            }
            case MODIFIED: {
                return SVNMessages.Console_Status_Modified;
            }
            case DELETED: {
                return SVNMessages.Console_Status_Deleted;
            }
            case MISSING: {
                return SVNMessages.Console_Status_Missing;
            }
            case REPLACED: {
                return SVNMessages.Console_Status_Replaced;
            }
            case MERGED: {
                return SVNMessages.Console_Status_Merged;
            }
            case CONFLICTED: {
                return SVNMessages.Console_Status_Conflicted;
            }
            case OBSTRUCTED: {
                return SVNMessages.Console_Status_Obstructed;
            }
        }
        return null;
    }
}

