/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNCommitStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileConflictDetectionOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.operation.file.SVNFileStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CommitOperation
extends AbstractFileConflictDetectionOperation
implements IRevisionProvider,
IPostCommitErrorsProvider {
    protected SVNDepth depth;
    protected long options;
    protected String message;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;
    protected ArrayList<SVNCommitStatus> postCommitErrors;
    protected String[] paths;

    public CommitOperation(File[] files, String message, boolean recursive, boolean keepLocks) {
        this(files, message, SVNDepth.infinityOrEmpty(recursive), keepLocks ? 16L : 0L);
    }

    public CommitOperation(IFileProvider provider, String message, boolean recursive, boolean keepLocks) {
        this(provider, message, SVNDepth.infinityOrEmpty(recursive), keepLocks ? 16L : 0L);
    }

    public CommitOperation(File[] files, String message, SVNDepth depth, long options) {
        super("Operation_CommitFile", SVNMessages.class, files);
        this.message = message;
        this.depth = depth;
        this.options = options & 0x30L;
    }

    public CommitOperation(IFileProvider provider, String message, SVNDepth depth, long options) {
        super("Operation_CommitFile", SVNMessages.class, provider);
        this.message = message;
        this.depth = depth;
        this.options = options & 0x30L;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    @Override
    public SVNCommitStatus[] getPostCommitErrors() {
        return this.postCommitErrors == null ? null : this.postCommitErrors.toArray(new SVNCommitStatus[this.postCommitErrors.size()]);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        this.postCommitErrors = new ArrayList();
        File[] files = this.operableData();
        this.defineInitialResourceSet(files);
        if (this.depth == SVNDepth.INFINITY) {
            files = FileUtility.shrinkChildNodes(files, false);
        } else {
            FileUtility.reorder(files, true);
        }
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 4) != 0) {
            Map proxy2Resources = SVNUtility.splitRepositoryLocations(files);
            Iterator it = proxy2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
                this.performCommit(location, (List)entry.getValue(), monitor, proxy2Resources.size());
            }
        } else {
            Map project2Resources = SVNUtility.splitWorkingCopies(files);
            Iterator it = project2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false).getRepositoryLocation();
                this.performCommit(location, (List)entry.getValue(), monitor, project2Resources.size());
            }
        }
    }

    protected void performCommit(IRepositoryLocation location, List files, IProgressMonitor monitor, int total) {
        this.paths = FileUtility.asPathArray(files.toArray(new File[files.size()]));
        this.complexWriteToConsole(() -> {
            this.writeToConsole(0, "svn commit" + ISVNConnector.Options.asCommandLine(this.options));
            int i = 0;
            while (i < this.paths.length && !monitor.isCanceled()) {
                this.writeToConsole(0, " \"" + this.paths[i] + "\"");
                ++i;
            }
            this.writeToConsole(0, (this.depth == SVNDepth.INFINITY ? "" : " -N") + ((this.options & 0x10L) != 0L ? " --no-unlock" : "") + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
        });
        ISVNConnector proxy = location.acquireSVNProxy();
        this.protectStep(monitor1 -> {
            SVNCommitStatus status;
            SVNProgressMonitor svnMonitor = new SVNProgressMonitor(this, monitor1, null);
            proxy.commit(this.paths, this.message, null, this.depth, this.options, null, svnMonitor);
            SVNCommitStatus sVNCommitStatus = status = svnMonitor.getCommitStatuses().isEmpty() ? null : svnMonitor.getCommitStatuses().iterator().next();
            if (status != null && status.revision != -1L) {
                this.revisionsPairs.add(new IRevisionProvider.RevisionPair(status.revision, this.paths, location));
                String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(status.revision)});
                this.writeToConsole(1, message);
            }
            if (svnMonitor.getPostCommitErrors() != null) {
                this.postCommitErrors.addAll(svnMonitor.getPostCommitErrors());
            }
        }, monitor, total);
        location.releaseSVNProxy(proxy);
    }

    @Override
    public void reportStatus(int severity, String message, Throwable t) {
        if (t instanceof SVNConnectorUnresolvedConflictException) {
            this.hasUnresolvedConflict = true;
            this.conflictMessage = t.getMessage();
            String[] stringArray = this.paths;
            int n = this.paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                Iterator it = this.processed.iterator();
                while (it.hasNext()) {
                    File res = (File)it.next();
                    if (!new Path(res.getAbsolutePath()).equals((Object)new Path(path))) continue;
                    it.remove();
                    this.unprocessed.add(res);
                    break;
                }
                ++n2;
            }
        } else {
            super.reportStatus(severity, message, t);
        }
    }
}

