/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file.management;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.operation.file.IFileProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class DisconnectOperation
extends AbstractFileOperation {
    public DisconnectOperation(File[] files) {
        super("Operation_DisconnectFile", SVNMessages.class, files);
    }

    public DisconnectOperation(IFileProvider provider) {
        super("Operation_DisconnectFile", SVNMessages.class, provider);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.disconnect(this.operableData(), monitor);
    }

    protected void disconnect(File[] files, IProgressMonitor monitor) {
        files = FileUtility.shrinkChildNodes(files, true);
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            File meta = new File(files[i].getAbsolutePath() + "/" + SVNUtility.getSVNFolderName());
            FileUtility.deleteRecursive(meta, monitor);
            if (files[i].isDirectory()) {
                this.disconnect(files[i].listFiles(), monitor);
            }
            ++i;
        }
    }
}

