/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNCommitStatus;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CommitOperation
extends AbstractConflictDetectionOperation
implements IRevisionProvider,
IPostCommitErrorsProvider {
    protected SVNDepth depth;
    protected long options;
    protected String message;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;
    protected ArrayList<SVNCommitStatus> postCommitErrors;
    protected String[] paths;

    public CommitOperation(IResource[] resources, String message, boolean recursive, boolean keepLocks) {
        this(resources, message, SVNDepth.infinityOrEmpty(recursive), keepLocks ? 16L : 0L);
    }

    public CommitOperation(IResourceProvider provider, String message, boolean recursive, boolean keepLocks) {
        this(provider, message, SVNDepth.infinityOrEmpty(recursive), keepLocks ? 16L : 0L);
    }

    public CommitOperation(IResource[] resources, String message, SVNDepth depth, long options) {
        super("Operation_Commit", SVNMessages.class, resources);
        this.message = message;
        this.depth = depth;
        this.options = options & 0x30L;
    }

    public CommitOperation(IResourceProvider provider, String message, SVNDepth depth, long options) {
        super("Operation_Commit", SVNMessages.class, provider);
        this.message = message;
        this.depth = depth;
        this.options = options & 0x30L;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        this.postCommitErrors = new ArrayList();
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        if (this.depth == SVNDepth.INFINITY) {
            resources = FileUtility.shrinkChildNodesWithSwitched(resources);
        } else {
            FileUtility.reorder(resources, true);
        }
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 4) != 0) {
            Map proxy2Resources = SVNUtility.splitRepositoryLocations(resources);
            Iterator it = proxy2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
                this.performCommit(location, (List)entry.getValue(), monitor, proxy2Resources.size());
            }
        } else {
            Map<IProject, List<IResource>> project2Resources = SVNUtility.splitWorkingCopies(resources);
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            Iterator<Map.Entry<IProject, List<IResource>>> it = project2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry<IProject, List<IResource>> entry = it.next();
                IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
                this.performCommit(location, entry.getValue(), monitor, project2Resources.size());
            }
        }
    }

    protected void performCommit(IRepositoryLocation location, List resources, IProgressMonitor monitor, int total) {
        this.paths = FileUtility.asPathArray(resources.toArray(new IResource[0]));
        this.complexWriteToConsole(() -> {
            this.writeToConsole(0, "svn commit" + ISVNConnector.Options.asCommandLine(this.options));
            int i = 0;
            while (i < this.paths.length && !monitor.isCanceled()) {
                this.writeToConsole(0, " \"" + this.paths[i] + "\"");
                ++i;
            }
            this.writeToConsole(0, (this.depth == SVNDepth.INFINITY ? "" : " -N") + ((this.options & 0x10L) != 0L ? " --no-unlock" : "") + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
        });
        ISVNConnector proxy = location.acquireSVNProxy();
        this.protectStep(monitor1 -> {
            SVNCommitStatus status;
            SVNProgressMonitor svnMonitor = new SVNProgressMonitor(this, monitor1, null);
            proxy.commit(this.paths, this.message, null, this.depth, this.options, null, svnMonitor);
            SVNCommitStatus sVNCommitStatus = status = svnMonitor.getCommitStatuses().isEmpty() ? null : svnMonitor.getCommitStatuses().iterator().next();
            if (status != null && status.revision != -1L) {
                this.revisionsPairs.add(new IRevisionProvider.RevisionPair(status.revision, this.paths, location));
                String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(status.revision)});
                this.writeToConsole(1, message);
            }
            if (svnMonitor.getPostCommitErrors() != null) {
                this.postCommitErrors.addAll(svnMonitor.getPostCommitErrors());
            }
        }, monitor, total);
        location.releaseSVNProxy(proxy);
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    @Override
    public SVNCommitStatus[] getPostCommitErrors() {
        return this.postCommitErrors == null || this.postCommitErrors.size() == 0 ? null : this.postCommitErrors.toArray(new SVNCommitStatus[this.postCommitErrors.size()]);
    }

    @Override
    public void reportStatus(int severity, String message, Throwable t) {
        if (t instanceof SVNConnectorUnresolvedConflictException) {
            SVNConnectorUnresolvedConflictException ex;
            this.setUnresolvedConflict(true);
            StringBuilder messageBuf = new StringBuilder();
            if (t.getMessage() != null && t.getMessage().length() > 0) {
                messageBuf.append(t.getMessage());
            }
            if ((ex = (SVNConnectorUnresolvedConflictException)t).getErrorId() == 160024) {
                messageBuf.append(messageBuf.toString().endsWith("\n") ? "\n" : "\n\n");
                messageBuf.append(SVNMessages.CommitOperation_3);
            }
            this.setConflictMessage(messageBuf.toString());
            String[] stringArray = this.paths;
            int n = this.paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                IResource[] iResourceArray = this.getProcessed();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource res = iResourceArray[n4];
                    if (FileUtility.getResourcePath(res).equals((Object)new Path(path))) {
                        this.removeProcessed(res);
                        this.addUnprocessed(res);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            super.reportStatus(severity, message, t);
        }
    }
}

