/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UnlockOperation
extends AbstractWorkingCopyOperation {
    public UnlockOperation(IResource[] resources) {
        super("Operation_Unlock", SVNMessages.class, resources);
    }

    public UnlockOperation(IResourceProvider provider) {
        super("Operation_Unlock", SVNMessages.class, provider);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        ArrayList problems = new ArrayList();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        Map<IProject, List<IResource>> wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator<Map.Entry<IProject, List<IResource>>> it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry<IProject, List<IResource>> entry = it.next();
            IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
            String[] paths = FileUtility.asPathArray(entry.getValue().toArray(new IResource[0]));
            this.complexWriteToConsole(() -> {
                this.writeToConsole(0, "svn unlock" + ISVNConnector.Options.asCommandLine(4L));
                int i = 0;
                while (i < paths.length && !monitor.isCanceled()) {
                    this.writeToConsole(0, " \"" + paths[i] + "\"");
                    ++i;
                }
                this.writeToConsole(0, FileUtility.getUsernameParam(location.getUsername()) + "\n");
            });
            ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(monitor1 -> {
                ISVNNotificationCallback listener = info -> {
                    if (SVNNotification.PerformedAction.FAILED_UNLOCK == info.action) {
                        problems.add(info);
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, listener);
                try {
                    proxy.unlock(paths, 4L, new SVNProgressMonitor(this, monitor1, null));
                }
                finally {
                    SVNUtility.removeSVNNotifyListener(proxy, listener);
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
        if (!problems.isEmpty()) {
            StringBuilder res = new StringBuilder();
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                SVNNotification problem = (SVNNotification)iter.next();
                res.append(problem.errMsg);
                if (!iter.hasNext()) continue;
                res.append("\n\n");
            }
            throw new UnreportableException(res.toString());
        }
    }
}

