/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.SVNUtility;

public abstract class AbstractCopyMoveResourcesOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected IRepositoryResource destinationResource;
    protected String message;
    protected String resName;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;

    public AbstractCopyMoveResourcesOperation(String operationName, Class<? extends NLS> messagesClass, IRepositoryResource destinationResource, IRepositoryResource[] selectedResources, String message, String resName) {
        super(operationName, messagesClass, selectedResources);
        this.destinationResource = destinationResource;
        this.message = message;
        this.resName = resName;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        IRepositoryResource[] selectedResources = this.operableData();
        final SVNEntryRevisionReference[] refs = new SVNEntryRevisionReference[selectedResources.length];
        String[] paths = new String[selectedResources.length];
        int i = 0;
        while (i < selectedResources.length) {
            refs[i] = SVNUtility.getEntryRevisionReference(selectedResources[i]);
            paths[i] = refs[i].path;
            ++i;
        }
        final IRepositoryLocation location = selectedResources[0].getRepositoryLocation();
        final String dstUrl = this.destinationResource.getUrl() + (String)(this.resName != null && this.resName.length() > 0 ? "/" + this.resName : (selectedResources.length > 1 ? "" : "/" + selectedResources[0].getName()));
        ISVNNotificationCallback notify = new ISVNNotificationCallback(){
            private int i = 0;

            @Override
            public void notify(SVNNotification info) {
                if (this.i == refs.length) {
                    return;
                }
                String[] paths = AbstractCopyMoveResourcesOperation.this.getRevisionPaths(refs[this.i].path, dstUrl);
                AbstractCopyMoveResourcesOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, paths, location));
                String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                AbstractCopyMoveResourcesOperation.this.writeToConsole(1, message);
                ++this.i;
            }
        };
        ISVNConnector proxy = location.acquireSVNProxy();
        SVNUtility.addSVNNotifyListener(proxy, notify);
        try {
            this.runCopyMove(proxy, refs, paths, SVNUtility.encodeURL(dstUrl), monitor);
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }

    protected abstract String[] getRevisionPaths(String var1, String var2);

    protected abstract void runCopyMove(ISVNConnector var1, SVNEntryRevisionReference[] var2, String[] var3, String var4, IProgressMonitor var5) throws Exception;
}

