/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String destinationUrl;
    protected String message;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;

    public BranchTagOperation(String operationName, Class<? extends NLS> messagesClass, IRepositoryResource[] resources, IRepositoryResource destination, String message) {
        super("Operation_" + operationName, messagesClass, resources);
        this.destinationUrl = destination.getUrl();
        this.message = message;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        IRepositoryLocation location = resources[0].getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            block6: {
                int i;
                block5: {
                    i = 0;
                    if (!true) break block5;
                    if (i >= resources.length) return;
                    if (monitor.isCanceled()) break block6;
                }
                do {
                    Object current = resources[i];
                    String url2 = SVNUtility.encodeURL(this.destinationUrl);
                    ISVNNotificationCallback notify = info -> {
                        this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, new String[]{url2}, location));
                        String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                        this.writeToConsole(1, message);
                    };
                    SVNUtility.addSVNNotifyListener(proxy, notify);
                    this.protectStep(arg_0 -> this.lambda$1((IRepositoryResource)current, proxy, url2, arg_0), monitor, resources.length);
                    SVNUtility.removeSVNNotifyListener(proxy, notify);
                    ++i;
                    if (i >= resources.length) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    private /* synthetic */ void lambda$1(IRepositoryResource iRepositoryResource, ISVNConnector iSVNConnector, String string, IProgressMonitor monitor1) throws Exception {
        this.writeToConsole(0, "svn copy \"" + iRepositoryResource.getUrl() + "\" \"" + this.destinationUrl + "\" -r " + String.valueOf(iRepositoryResource.getSelectedRevision()) + " -m \"" + this.message + "\"" + ISVNConnector.Options.asCommandLine(32768L) + FileUtility.getUsernameParam(iRepositoryResource.getRepositoryLocation().getUsername()) + "\n");
        SVNEntryRevisionReference[] src = new SVNEntryRevisionReference[]{new SVNEntryRevisionReference(SVNUtility.encodeURL(iRepositoryResource.getUrl()), iRepositoryResource.getPegRevision(), iRepositoryResource.getSelectedRevision())};
        iSVNConnector.copyRemote(src, string, this.message, 32768L, null, ISVNConnector.NO_EXTERNALS_TO_PIN, new SVNProgressMonitor(this, monitor1, null));
    }
}

