/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreateFolderOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String[] names;
    protected String comment;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFolderOperation(IRepositoryResource parent, String name, String comment) {
        this(parent, new String[]{name}, comment);
    }

    public CreateFolderOperation(IRepositoryResource parent, String[] names, String comment) {
        super("Operation_CreateFolder", SVNMessages.class, new IRepositoryResource[]{parent});
        this.names = names;
        this.comment = comment;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        IRepositoryResource parent = this.operableData()[0];
        IRepositoryLocation location = parent.getRepositoryLocation();
        ProgressMonitorUtility.setTaskInfo(monitor, this, parent.getUrl() + "/" + this.names[0]);
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            fullSet.addAll(Arrays.asList(SVNUtility.makeResourceSet(parent, name2, false)));
            ++n2;
        }
        IRepositoryResource[] toBeCreated = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        Object[] childUrls = SVNUtility.asURLArray(toBeCreated, true);
        Arrays.sort(childUrls);
        ISVNNotificationCallback notify = arg_0 -> this.lambda$0((String[])childUrls, location, arg_0);
        this.complexWriteToConsole(() -> this.lambda$1((String[])childUrls, monitor, location));
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            proxy.mkdir((String[])childUrls, this.comment, 0L, null, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            parent.getRepositoryLocation().releaseSVNProxy(proxy);
        }
        ProgressMonitorUtility.progress(monitor, 1, 1);
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.name});
    }

    private /* synthetic */ void lambda$0(String[] stringArray, IRepositoryLocation iRepositoryLocation, SVNNotification info) {
        String[] path = stringArray;
        this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, iRepositoryLocation);
        String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
        this.writeToConsole(1, message);
    }

    private /* synthetic */ void lambda$1(String[] stringArray, IProgressMonitor iProgressMonitor, IRepositoryLocation iRepositoryLocation) {
        this.writeToConsole(0, "svn mkdir");
        int i = 0;
        while (i < stringArray.length && !iProgressMonitor.isCanceled()) {
            this.writeToConsole(0, " \"" + SVNUtility.decodeURL(stringArray[i]) + "\"");
            ++i;
        }
        this.writeToConsole(0, " -m \"" + this.comment + "\"" + FileUtility.getUsernameParam(iRepositoryLocation.getUsername()) + "\n");
    }
}

