/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.IMergeSyncInfo;

public class MergeSyncInfo
extends AbstractSVNSyncInfo
implements IMergeSyncInfo {
    protected IResourceChange baseStatus;

    public MergeSyncInfo(ILocalResource local, IResourceChange base, IResourceChange remote, IResourceVariantComparator comparator) {
        super(local, base == null ? AbstractSVNSyncInfo.makeBaseVariant(local) : AbstractSVNSyncInfo.makeRemoteVariant(local, base), AbstractSVNSyncInfo.makeRemoteVariant(local, remote), comparator, remote);
        this.baseStatus = base;
    }

    protected int calculateKind() throws TeamException {
        int remoteMask;
        int localMask;
        String localKind = this.local == null ? IStateFilter.ST_NOTEXISTS : this.local.getStatus();
        int n = localMask = this.local == null ? 0 : this.local.getChangeMask();
        String remoteKind = this.remoteStatus == null ? (this.isNonVersioned(localKind, localMask) ? IStateFilter.ST_NOTEXISTS : "Normal") : this.remoteStatus.getStatus();
        int n2 = remoteMask = this.remoteStatus == null ? 0 : this.remoteStatus.getChangeMask();
        if (this.isLinked(localKind, localMask)) {
            if (this.isAdded(remoteKind, remoteMask)) {
                this.localKind = 5;
                this.remoteKind = 9;
                return 13;
            }
            if (this.isModified(remoteKind, remoteMask) || this.isReplaced(remoteKind, remoteMask)) {
                this.localKind = 5;
                this.remoteKind = 11;
                return 15;
            }
            if (this.isDeleted(remoteKind, remoteMask)) {
                this.localKind = 5;
                this.remoteKind = 10;
                return 14;
            }
            return 0;
        }
        if (this.isTreeConflicted(localKind, localMask) || this.isTreeConflicted(remoteKind, remoteMask)) {
            this.localKind = 7;
            this.remoteKind = 11;
            return 15;
        }
        if (this.isAdded(remoteKind, remoteMask)) {
            this.remoteKind = 9;
            if (this.isNotExists(localKind, localMask) || this.isDeleted(localKind, localMask)) {
                return 9;
            }
            this.localKind = 5;
            return 13;
        }
        if (this.isConflicted(remoteKind, remoteMask)) {
            this.localKind = 7;
            this.remoteKind = 11;
            return 15;
        }
        if (this.isModified(remoteKind, remoteMask)) {
            this.remoteKind = 11;
            if (this.isNotExists(localKind, localMask)) {
                this.remoteKind = 9;
                return 9;
            }
            if (this.isDeleted(localKind, localMask)) {
                this.localKind = 6;
                return 14;
            }
            return 11;
        }
        if (this.isDeleted(remoteKind, remoteMask)) {
            this.remoteKind = 10;
            if (this.isNotExists(localKind, localMask) || this.isDeleted(localKind, localMask)) {
                this.remoteKind = 0;
                return 0;
            }
            if (this.isNotModified(localKind, localMask)) {
                return 10;
            }
            this.localKind = 7;
            return 14;
        }
        return 0;
    }

    @Override
    public ILocalResource getBaseChangeResource() {
        return this.baseStatus == null ? this.local : this.baseStatus;
    }

    @Override
    public IResourceChange getBaseResource() {
        return this.baseStatus;
    }

    @Override
    public IResourceChange getRemoteResource() {
        return this.remoteStatus;
    }
}

