/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class HttpHeaderParser {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char HT = '\t';
    private static final char SP = ' ';
    private static boolean[] tchar;
    private static boolean[] fieldvchar;
    private StringBuilder sb = new StringBuilder();
    private Map<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
    private List<String> keyList = new ArrayList<String>();
    private String requestOrStatusLine;
    private int responseCode;
    private boolean eof;
    private State state = State.INITIAL;

    public HttpHeaderParser() {
    }

    public HttpHeaderParser(InputStream is) throws IOException, ProtocolException {
        this.parse(is);
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headerMap;
    }

    public List<String> getHeaderValue(String key) {
        if (this.headerMap.containsKey(key.toLowerCase(Locale.ROOT))) {
            return this.headerMap.get(key.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public List<String> getValue(int id) {
        String key = this.keyList.get(id);
        return this.headerMap.get(key);
    }

    public String getRequestDetails() {
        return this.requestOrStatusLine;
    }

    public boolean parse(InputStream input) throws IOException {
        Objects.requireNonNull(input, "null input");
        block11: while (this.canContinueParsing()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = State.STATUS_OR_REQUEST_LINE;
                    continue block11;
                }
                case 1: {
                    this.readResumeStatusLine(input);
                    continue block11;
                }
                case 2: 
                case 3: {
                    this.readStatusLineFeed(input);
                    continue block11;
                }
                case 4: {
                    this.maybeStartHeaders(input);
                    continue block11;
                }
                case 5: 
                case 6: {
                    this.maybeEndHeaders(input);
                    continue block11;
                }
                case 7: {
                    this.readResumeHeader(input);
                    continue block11;
                }
                case 8: 
                case 9: {
                    this.resumeOrLF(input);
                    continue block11;
                }
                case 10: {
                    this.resumeOrSecondCR(input);
                    continue block11;
                }
                case 11: {
                    this.resumeOrEndHeaders(input);
                    continue block11;
                }
            }
            throw new InternalError("Unexpected state: " + String.valueOf((Object)this.state));
        }
        return this.state == State.FINISHED;
    }

    private boolean canContinueParsing() {
        return switch (this.state.ordinal()) {
            case 12 -> false;
            case 3, 6, 9 -> true;
            default -> !this.eof;
        };
    }

    private char get(InputStream input) throws IOException {
        int c = input.read();
        if (c < 0) {
            this.eof = true;
        }
        return (char)(c & 0xFF);
    }

    private void readResumeStatusLine(InputStream input) throws IOException {
        char c;
        while ((c = this.get(input)) != '\r' && !this.eof && c != '\n') {
            this.sb.append(c);
        }
        if (c == '\r') {
            this.state = State.STATUS_OR_REQUEST_LINE_FOUND_CR;
        } else if (c == '\n') {
            this.state = State.STATUS_OR_REQUEST_LINE_FOUND_LF;
        }
    }

    private void readStatusLineFeed(InputStream input) throws IOException {
        char c;
        char c2 = c = this.state == State.STATUS_OR_REQUEST_LINE_FOUND_LF ? (char)'\n' : (char)this.get(input);
        if (c != '\n') {
            throw this.protocolException("Bad trailing char, \"%s\", when parsing status line, \"%s\"", Character.valueOf(c), this.sb.toString());
        }
        this.requestOrStatusLine = this.sb.toString();
        this.sb = new StringBuilder();
        if (!this.requestOrStatusLine.startsWith("HTTP/1.")) {
            if (!(this.requestOrStatusLine.startsWith("GET") || this.requestOrStatusLine.startsWith("POST") || this.requestOrStatusLine.startsWith("PUT") || this.requestOrStatusLine.startsWith("DELETE") || this.requestOrStatusLine.startsWith("OPTIONS") || this.requestOrStatusLine.startsWith("HEAD") || this.requestOrStatusLine.startsWith("PATCH") || this.requestOrStatusLine.startsWith("CONNECT"))) {
                throw this.protocolException("Invalid request Or Status line: \"%s\"", this.requestOrStatusLine);
            }
            System.out.println("Request is :" + this.requestOrStatusLine);
        } else {
            if (this.requestOrStatusLine.length() < 12) {
                throw this.protocolException("Invalid status line: \"%s\"", this.requestOrStatusLine);
            }
            try {
                this.responseCode = Integer.parseInt(this.requestOrStatusLine.substring(9, 12));
            }
            catch (NumberFormatException nfe) {
                throw this.protocolException("Invalid status line: \"%s\"", this.requestOrStatusLine);
            }
            if (this.responseCode < 100) {
                throw this.protocolException("Invalid status line: \"%s\"", this.requestOrStatusLine);
            }
        }
        this.state = State.STATUS_OR_REQUEST_LINE_END;
    }

    private void maybeStartHeaders(InputStream input) throws IOException {
        assert (this.state == State.STATUS_OR_REQUEST_LINE_END);
        assert (this.sb.length() == 0);
        char c = this.get(input);
        if (!this.eof) {
            if (c == '\r') {
                this.state = State.STATUS_OR_REQUEST_LINE_END_CR;
            } else if (c == '\n') {
                this.state = State.STATUS_OR_REQUEST_LINE_END_LF;
            } else {
                this.sb.append(c);
                this.state = State.HEADER;
            }
        }
    }

    private void maybeEndHeaders(InputStream input) throws IOException {
        char c;
        assert (this.state == State.STATUS_OR_REQUEST_LINE_END_CR || this.state == State.STATUS_OR_REQUEST_LINE_END_LF);
        assert (this.sb.length() == 0);
        char c2 = c = this.state == State.STATUS_OR_REQUEST_LINE_END_LF ? (char)'\n' : (char)this.get(input);
        if (c != '\n') {
            throw this.protocolException("Unexpected \"%s\", after status line CR", Character.valueOf(c));
        }
        this.state = State.FINISHED;
    }

    private void readResumeHeader(InputStream input) throws IOException {
        assert (this.state == State.HEADER);
        assert (!this.eof);
        char c = this.get(input);
        while (!this.eof) {
            if (c == '\r') {
                this.state = State.HEADER_FOUND_CR;
                break;
            }
            if (c == '\n') {
                this.state = State.HEADER_FOUND_LF;
                break;
            }
            if (c == '\t') {
                c = ' ';
            }
            this.sb.append(c);
            c = this.get(input);
        }
    }

    private void addHeaderFromString(String headerString) throws ProtocolException {
        assert (this.sb.length() == 0);
        int idx = headerString.indexOf(58);
        if (idx == -1) {
            return;
        }
        String name = headerString.substring(0, idx);
        if (name.isEmpty()) {
            return;
        }
        if (!this.isValidName(name)) {
            throw this.protocolException("Invalid header name \"%s\"", name);
        }
        String value = headerString.substring(idx + 1).trim();
        if (!this.isValidValue(value)) {
            throw this.protocolException("Invalid header value \"%s: %s\"", name, value);
        }
        this.keyList.add(name);
        this.headerMap.computeIfAbsent(name.toLowerCase(Locale.US), k -> new ArrayList()).add(value);
    }

    private void resumeOrLF(InputStream input) throws IOException {
        char c;
        assert (this.state == State.HEADER_FOUND_CR || this.state == State.HEADER_FOUND_LF);
        char c2 = c = this.state == State.HEADER_FOUND_LF ? (char)'\n' : (char)this.get(input);
        if (!this.eof) {
            if (c == '\n') {
                this.state = State.HEADER_FOUND_CR_LF;
            } else if (c == ' ' || c == '\t') {
                this.sb.append(' ');
                this.state = State.HEADER;
            } else {
                this.sb = new StringBuilder();
                this.sb.append(c);
                this.state = State.HEADER;
            }
        }
    }

    private void resumeOrSecondCR(InputStream input) throws IOException {
        assert (this.state == State.HEADER_FOUND_CR_LF);
        char c = this.get(input);
        if (!this.eof) {
            if (c == '\r' || c == '\n') {
                if (this.sb.length() > 0) {
                    String headerString = this.sb.toString();
                    this.sb = new StringBuilder();
                    this.addHeaderFromString(headerString);
                }
                this.state = c == '\r' ? State.HEADER_FOUND_CR_LF_CR : State.FINISHED;
            } else if (c == ' ' || c == '\t') {
                assert (this.sb.length() != 0);
                this.sb.append(' ');
                this.state = State.HEADER;
            } else {
                if (this.sb.length() > 0) {
                    String headerString = this.sb.toString();
                    this.sb = new StringBuilder();
                    this.addHeaderFromString(headerString);
                }
                this.sb.append(c);
                this.state = State.HEADER;
            }
        }
    }

    private void resumeOrEndHeaders(InputStream input) throws IOException {
        assert (this.state == State.HEADER_FOUND_CR_LF_CR);
        char c = this.get(input);
        if (!this.eof) {
            if (c == '\n') {
                this.state = State.FINISHED;
            } else {
                throw this.protocolException("Unexpected \"%s\", after CR LF CR", Character.valueOf(c));
            }
        }
    }

    private ProtocolException protocolException(String format, Object ... args) {
        return new ProtocolException(String.format(format, args));
    }

    public boolean isValidName(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c <= '\u00ff' && tchar[c]) continue;
            return false;
        }
        return !token.isEmpty();
    }

    public boolean isValidValue(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c > '\u00ff') {
                return false;
            }
            if (c == ' ' || c == '\t' || fieldvchar[c]) continue;
            return false;
        }
        return true;
    }

    static {
        char[] allowedTokenChars;
        tchar = new boolean[256];
        fieldvchar = new boolean[256];
        for (char c : allowedTokenChars = "!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            HttpHeaderParser.tchar[c] = true;
        }
        for (int c = 33; c <= 255; c = (int)((char)(c + 1))) {
            HttpHeaderParser.fieldvchar[c] = true;
        }
        HttpHeaderParser.fieldvchar[127] = false;
    }

    static enum State {
        INITIAL,
        STATUS_OR_REQUEST_LINE,
        STATUS_OR_REQUEST_LINE_FOUND_CR,
        STATUS_OR_REQUEST_LINE_FOUND_LF,
        STATUS_OR_REQUEST_LINE_END,
        STATUS_OR_REQUEST_LINE_END_CR,
        STATUS_OR_REQUEST_LINE_END_LF,
        HEADER,
        HEADER_FOUND_CR,
        HEADER_FOUND_LF,
        HEADER_FOUND_CR_LF,
        HEADER_FOUND_CR_LF_CR,
        FINISHED;

    }
}

