/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ValidatorIntegerInput;

public class ValidatorIntegerRangeInput
extends ValidatorIntegerInput {
    private int minRange;
    private int maxRange;
    private int orgMinRange;
    private int orgMaxRange;
    private Integer minRangeInt;
    private Integer maxRangeInt;
    private SystemMessage msg_InvalidRange = RSEUIPlugin.getPluginMessage("RSEG1172");

    public ValidatorIntegerRangeInput(int minRange, int maxRange) {
        this(minRange, maxRange, false);
    }

    public ValidatorIntegerRangeInput(int minRange, int maxRange, boolean allowBlank) {
        super(RSEUIPlugin.getPluginMessage("RSEG1170"), RSEUIPlugin.getPluginMessage("RSEG1171"));
        this.orgMinRange = minRange;
        this.orgMaxRange = maxRange;
        super.setBlankAllowed(allowBlank);
        this.setRange(minRange, maxRange);
    }

    public void setRange(int minRange, int maxRange) {
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.minRangeInt = new Integer(minRange);
        this.maxRangeInt = new Integer(maxRange);
    }

    public void restoreRange() {
        this.setRange(this.orgMinRange, this.orgMaxRange);
    }

    public void setErrorMessages(SystemMessage emptyMsg, SystemMessage invalidMsg, SystemMessage outOfRangeMsg) {
        super.setErrorMessages(emptyMsg, invalidMsg);
        this.msg_InvalidRange = outOfRangeMsg;
    }

    public int getMaximumNameLength() {
        int maxlen = Integer.toString(Math.abs(this.maxRange)).length();
        if (this.maxRange < 0) {
            ++maxlen;
        }
        return maxlen;
    }

    public String isValid(String input) {
        String msg = super.isValid(input);
        if (msg == null && input != null && input.length() > 0 && (this.number < this.minRange || this.number > this.maxRange)) {
            this.currentMessage = this.msg_InvalidRange;
            this.currentMessage.makeSubstitution((Object)input, (Object)this.minRangeInt, (Object)this.maxRangeInt);
            msg = this.currentMessage.getLevelOneText();
        }
        return msg;
    }
}

