/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui.actions;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.examples.dsf.pda.service.PDACommandControl;
import org.eclipse.cdt.examples.dsf.pda.service.PDAVirtualMachineDMContext;
import org.eclipse.cdt.examples.dsf.pda.ui.PDAUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class PDATerminateCommand
implements ITerminateHandler {
    private final DsfSession fSession;
    private final DsfServicesTracker fTracker;

    public PDATerminateCommand(DsfSession session) {
        this.fSession = session;
        this.fTracker = new DsfServicesTracker(PDAUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final PDAVirtualMachineDMContext pdaProgramCtx = (PDAVirtualMachineDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), PDAVirtualMachineDMContext.class);
        if (pdaProgramCtx == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    PDACommandControl commandControl = (PDACommandControl)PDATerminateCommand.this.fTracker.getService(PDACommandControl.class);
                    if (commandControl == null || pdaProgramCtx == null) {
                        request.setEnabled(false);
                        request.done();
                    } else {
                        request.setEnabled(!commandControl.isTerminated());
                        request.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            request.setEnabled(false);
            request.done();
        }
    }

    public boolean execute(final IDebugCommandRequest request) {
        try {
            this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    PDACommandControl commandControl = (PDACommandControl)PDATerminateCommand.this.fTracker.getService(PDACommandControl.class);
                    if (commandControl != null) {
                        commandControl.terminate(new RequestMonitor(ImmediateExecutor.getInstance(), null){

                            protected void handleCompleted() {
                                request.setStatus(this.getStatus());
                                request.done();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            request.setStatus((IStatus)new Status(4, PDAUIPlugin.PLUGIN_ID, "PDA debug session is shut down."));
            request.done();
        }
        return false;
    }
}

