/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.actions;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.gef.examples.text.actions.StyleListener;
import org.eclipse.gef.examples.text.actions.StyleProvider;

public class StyleService {
    public static final Object STATE_EDITABLE = new Object();
    public static final Object STATE_READ_ONLY = new Object();
    public static final Object UNDEFINED = new Object();
    private List<StyleListener> listeners = new CopyOnWriteArrayList<StyleListener>();
    private StyleProvider provider;
    private StyleListener providerListener = this::propogateChange;

    public void addStyleListener(StyleListener listener) {
        this.listeners.add(listener);
    }

    public Object getStyle(String styleID) {
        if (this.provider != null) {
            return this.provider.getStyle(styleID);
        }
        return UNDEFINED;
    }

    public Object getStyleState(String styleID) {
        if (this.provider != null) {
            return this.provider.getStyleState(styleID);
        }
        return UNDEFINED;
    }

    protected void propogateChange(String styleID) {
        this.listeners.forEach(listener -> listener.styleChanged(styleID));
    }

    public void removeStyleListener(StyleListener listener) {
        this.listeners.remove(listener);
    }

    public void setStyle(String styleID, Object value) {
        if (this.provider != null) {
            this.provider.setStyle(styleID, value);
        }
    }

    public void setStyleProvider(StyleProvider provider) {
        if (this.provider == provider) {
            return;
        }
        if (this.provider != null) {
            this.provider.removeStyleListener(this.providerListener);
        }
        this.provider = provider;
        if (this.provider != null) {
            this.provider.addStyleListener(this.providerListener);
        }
        this.propogateChange(null);
    }
}

