/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.palette;

import java.util.Set;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.examples.Messages;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.gef.ui.palette.customize.PaletteSettingsDialog;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class PaletteSnippet1
extends ViewPart {
    private static final String PREFERENCE_DRAWER_FONT = "drawer-font";
    private static final String PREFERENCE_ENTRY_FONT = "entry-font";
    private static final Set<String> FONT_PROPERTIES = Set.of("drawer-font", "entry-font");
    private final SnippetPreferences preferences;
    private final PaletteRoot paletteRoot;
    private PaletteViewer paletteViewer;
    private Font drawerFont;
    private Font entryFont;

    public PaletteSnippet1() {
        PaletteDrawer paletteDrawer = new PaletteDrawer(Messages.PaletteSnippet1_System);
        paletteDrawer.add((PaletteEntry)new SelectionToolEntry());
        this.paletteRoot = new PaletteRoot();
        this.paletteRoot.add((PaletteEntry)paletteDrawer);
        this.preferences = new SnippetPreferences();
        this.preferences.addPropertyChangeListener(event -> {
            if (FONT_PROPERTIES.contains(event.getPropertyName())) {
                this.updateFonts(event.getPropertyName());
                this.paletteViewer.getRootEditPart().refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.drawerFont = new Font((Device)parent.getDisplay(), this.preferences.getFontData(PREFERENCE_DRAWER_FONT));
        this.entryFont = new Font((Device)parent.getDisplay(), this.preferences.getFontData(PREFERENCE_ENTRY_FONT));
        this.paletteViewer = new PaletteViewer();
        this.paletteViewer.createControl(parent);
        this.paletteViewer.setPaletteRoot(this.paletteRoot);
        this.paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)this.preferences);
        this.paletteViewer.setContextMenu((MenuManager)new SnippetContextMenu(this.paletteViewer));
        this.updateFonts((String)null);
    }

    public void setFocus() {
        if (this.paletteViewer != null) {
            this.paletteViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.drawerFont != null) {
            this.drawerFont.dispose();
        }
        if (this.entryFont != null) {
            this.entryFont.dispose();
        }
        super.dispose();
    }

    private void updateFonts(String propertyName) {
        Display display = this.paletteViewer.getControl().getDisplay();
        if (PREFERENCE_DRAWER_FONT.equals(propertyName)) {
            if (this.drawerFont != null) {
                this.drawerFont.dispose();
            }
            this.drawerFont = new Font((Device)display, this.preferences.getFontData(PREFERENCE_DRAWER_FONT));
        } else if (PREFERENCE_ENTRY_FONT.equals(propertyName)) {
            if (this.entryFont != null) {
                this.entryFont.dispose();
            }
            this.entryFont = new Font((Device)display, this.preferences.getFontData(PREFERENCE_ENTRY_FONT));
        }
        this.updateFonts((PaletteEditPart)this.paletteViewer.getEditPartForModel((Object)this.paletteRoot));
        FigureCanvas figureCanvas = (FigureCanvas)this.paletteViewer.getControl();
        figureCanvas.getViewport().invalidateTree();
        figureCanvas.getViewport().revalidate();
        figureCanvas.redraw();
        this.paletteViewer.getRootEditPart().refresh();
    }

    private void updateFonts(PaletteEditPart editPart) {
        if (editPart.getModel() instanceof ToolEntry) {
            editPart.getFigure().setFont(this.entryFont);
        } else if (editPart.getModel() instanceof PaletteDrawer) {
            editPart.getFigure().setFont(this.drawerFont);
        }
        for (PaletteEditPart childEditPart : editPart.getChildren()) {
            this.updateFonts(childEditPart);
        }
    }

    private static class SnippetContextMenu
    extends PaletteContextMenuProvider {
        public SnippetContextMenu(PaletteViewer palette) {
            super(palette);
        }

        public void buildContextMenu(IMenuManager menu) {
            GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new SnippetSettingsAction(this.getPaletteViewer()));
        }
    }

    private class SnippetPreferences
    extends DefaultPaletteViewerPreferences {
        private static final String DEFAULT_FONT = "Default";

        public SnippetPreferences() {
            super((IPreferenceStore)new PreferenceStore());
            this.getPreferenceStore().setDefault(PaletteSnippet1.PREFERENCE_DRAWER_FONT, DEFAULT_FONT);
            this.getPreferenceStore().setDefault(PaletteSnippet1.PREFERENCE_ENTRY_FONT, DEFAULT_FONT);
        }

        public void setFontData(String property, FontData fontData) {
            String value = fontData.toString();
            if (fontData.equals((Object)JFaceResources.getDialogFont().getFontData()[0])) {
                value = DEFAULT_FONT;
            }
            this.getPreferenceStore().setValue(property, value);
        }

        public FontData getFontData(String property) {
            String value = this.getPreferenceStore().getString(property);
            if (value.equals(DEFAULT_FONT)) {
                return JFaceResources.getDialogFont().getFontData()[0];
            }
            return new FontData(value);
        }

        protected void handlePreferenceStorePropertyChanged(String property) {
            if (FONT_PROPERTIES.contains(property)) {
                this.firePropertyChanged(property, this.getFontData(property));
            } else {
                super.handlePreferenceStorePropertyChanged(property);
            }
        }
    }

    private static class SnippetSettingsAction
    extends SettingsAction {
        private final Shell shell;
        private final SnippetPreferences prefs;

        public SnippetSettingsAction(PaletteViewer palette) {
            super(palette);
            this.shell = palette.getControl().getShell();
            this.prefs = (SnippetPreferences)palette.getPaletteViewerPreferences();
        }

        public void run() {
            SnippetSettingsDialog settings = new SnippetSettingsDialog(this.shell, this.prefs);
            settings.open();
        }
    }

    private static class SnippetSettingsDialog
    extends PaletteSettingsDialog {
        private static final String CACHE_DRAWER_FONT = "drawer-font";
        private static final String CACHE_ENTRY_FONT = "entry-font";
        protected static final int DRAWER_FONT_CHANGE_ID = 17;
        protected static final int DRAWER_DEFAULT_FONT_ID = 18;
        protected static final int ENTRY_FONT_CHANGE_ID = 19;
        protected static final int ENTRY_DEFAULT_FONT_ID = 20;
        protected SnippetPreferences prefs;
        protected Label drawerFontName;
        protected Label entryFontName;

        public SnippetSettingsDialog(Shell parentShell, SnippetPreferences prefs) {
            super(parentShell, (PaletteViewerPreferences)prefs);
            this.prefs = prefs;
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 17: {
                    this.handleChangeFontPressed("drawer-font");
                    break;
                }
                case 18: {
                    this.handleDefaultFontRequested("drawer-font");
                    break;
                }
                case 19: {
                    this.handleChangeFontPressed("entry-font");
                    break;
                }
                case 20: {
                    this.handleDefaultFontRequested("entry-font");
                    break;
                }
                default: {
                    super.buttonPressed(buttonId);
                }
            }
        }

        protected void restoreSettings() {
            super.restoreSettings();
            this.prefs.setFontData("drawer-font", (FontData)this.settings.get("drawer-font"));
            this.prefs.setFontData("entry-font", (FontData)this.settings.get("entry-font"));
        }

        protected void cacheSettings() {
            super.cacheSettings();
            this.settings.put("drawer-font", this.prefs.getFontData("drawer-font"));
            this.settings.put("entry-font", this.prefs.getFontData("entry-font"));
        }

        protected Control createFontSettings(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            this.drawerFontName = new Label(container, 16448);
            this.drawerFontName.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.createButton(container, 17, PaletteMessages.SETTINGS_FONT_CHANGE, 8, null);
            this.createButton(container, 18, PaletteMessages.SETTINGS_DEFAULT_FONT, 8, null);
            this.entryFontName = new Label(container, 16448);
            this.entryFontName.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.createButton(container, 19, PaletteMessages.SETTINGS_FONT_CHANGE, 8, null);
            this.createButton(container, 20, PaletteMessages.SETTINGS_DEFAULT_FONT, 8, null);
            this.updateFontName();
            return container;
        }

        protected void updateFontName() {
            this.drawerFontName.setText(Messages.bind((String)Messages.PaletteSnippet1_Drawer_Font, (Object)this.getFontName("drawer-font")));
            this.entryFontName.setText(Messages.bind((String)Messages.PaletteSnippet1_Entry_Font, (Object)this.getFontName("entry-font")));
        }

        protected void handleChangeFontPressed(String property) {
            FontDialog dialog = new FontDialog(this.getShell());
            FontData data = this.prefs.getFontData(property);
            dialog.setFontList(new FontData[]{data});
            data = dialog.open();
            if (data != null) {
                this.prefs.setFontData(property, data);
            }
            this.updateFontName();
        }

        protected void handleDefaultFontRequested(String property) {
            this.prefs.setFontData(property, JFaceResources.getDialogFont().getFontData()[0]);
            this.updateFontName();
        }

        protected String getFontName(String property) {
            if (this.prefs.getFontData(property).equals((Object)JFaceResources.getDialogFont().getFontData()[0])) {
                return PaletteMessages.SETTINGS_WORKBENCH_FONT_LABEL;
            }
            return StringConverter.asString((FontData)this.prefs.getFontData(property));
        }
    }
}

