/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core;

import java.util.List;

/**
 * One of the central types of the TRACE data model.
 *
 *
 * <p>
 * A time-series, consisting of one or more {@link ITSSeries} instances.
 * </p>
 */
public interface ITimeSeries extends IAttributeAware {
    /**
     * @param id the series identifier to be added
     *
     */
    void addSeries(Integer id, ITSSeries series);

    /**
     * @param id the series identifier
     * @return the series with the given {@link id}.
     */
    ITSSeries getSeries(Integer id);

    /**
     * The series are ordered by their id.
     *
     * @return all series which are part of this {@link ITimeSeries}
     */
    List<ITSSeries> getAllSeries();
}
