/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalPointer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecBreak;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecCase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecContinue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDefault;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDo;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecFor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIf;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecRangeBasedFor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecStaticAssert;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSwitch;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecWhile;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class EvalUtil {
    private static final ThreadLocal<Set<ICPPVariable>> fInitialValueInProgress = new ThreadLocal<Set<ICPPVariable>>(){

        @Override
        protected Set<ICPPVariable> initialValue() {
            return new HashSet<ICPPVariable>();
        }
    };

    public static IValue getConditionExprValue(ICPPEvaluation conditionExprEval, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return conditionExprEval.computeForFunctionCall(record, context.recordStep()).getValue();
    }

    public static IValue getConditionDeclValue(ExecSimpleDeclaration conditionDeclExec, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPBinding declaredBinding = ((ExecDeclarator)conditionDeclExec.getDeclaratorExecutions()[0]).getDeclaredBinding();
        conditionDeclExec.executeForFunctionCall(record, context.recordStep());
        return record.getVariable(declaredBinding).computeForFunctionCall(record, context).getValue();
    }

    public static boolean conditionExprSatisfied(ICPPEvaluation conditionExprEval, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        Number result = EvalUtil.getConditionExprValue(conditionExprEval, record, context).numberValue();
        return result != null && result.longValue() != 0L;
    }

    public static boolean conditionDeclSatisfied(ExecSimpleDeclaration conditionDeclExec, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        Number result = EvalUtil.getConditionDeclValue(conditionDeclExec, record, context).numberValue();
        return result != null && result.longValue() != 0L;
    }

    public static ICPPExecution getExecutionFromStatement(IASTStatement stmt) {
        if (stmt instanceof ICPPExecutionOwner) {
            ICPPExecutionOwner execOwner = (ICPPExecutionOwner)((Object)stmt);
            return execOwner.getExecution();
        }
        return null;
    }

    public static ICPPExecution executeStatement(ICPPExecution exec, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (exec instanceof ExecExpressionStatement || exec instanceof ExecDeclarationStatement || exec instanceof ExecCase || exec instanceof ExecDefault) {
            ICPPExecution result = exec.executeForFunctionCall(record, context.recordStep());
            if (result instanceof ExecStaticAssert) {
                return result;
            }
            return null;
        }
        if (exec instanceof ExecCompoundStatement || exec instanceof ExecWhile || exec instanceof ExecFor || exec instanceof ExecRangeBasedFor || exec instanceof ExecDo || exec instanceof ExecIf || exec instanceof ExecSwitch || exec instanceof ExecStaticAssert) {
            ICPPExecution innerResult = exec.executeForFunctionCall(record, context.recordStep());
            if (innerResult instanceof ExecReturn || innerResult instanceof ExecBreak || innerResult instanceof ExecContinue || innerResult instanceof ExecStaticAssert) {
                return innerResult;
            }
            if (innerResult != null) {
                return ExecIncomplete.INSTANCE;
            }
            return null;
        }
        return exec;
    }

    private static boolean isUpdateable(ICPPEvaluation eval) {
        return eval instanceof EvalBinding || eval instanceof EvalReference && !(eval instanceof EvalPointer) || eval instanceof EvalCompositeAccess;
    }

    public static Pair<ICPPEvaluation, ICPPEvaluation> getValuePair(ICPPEvaluation eval, ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation fixed;
        ICPPEvaluation updateable = null;
        if (EvalUtil.isUpdateable(eval)) {
            updateable = eval;
        }
        if ((fixed = eval.computeForFunctionCall(record, context.recordStep())) == EvalFixed.INCOMPLETE) {
            updateable = fixed;
        } else if (EvalUtil.isUpdateable(fixed)) {
            updateable = fixed;
            if (!(fixed instanceof EvalCompositeAccess)) {
                fixed = fixed.computeForFunctionCall(record, context);
            }
        }
        return new Pair<ICPPEvaluation, ICPPEvaluation>(updateable, fixed);
    }

    public static boolean isCompilerGeneratedCtor(IBinding ctor) {
        if (ctor instanceof ICPPSpecialization) {
            ICPPSpecialization ctorSpec = (ICPPSpecialization)ctor;
            return EvalUtil.isCompilerGeneratedCtor(ctorSpec.getSpecializedBinding());
        }
        return ctor instanceof ICPPConstructor && ((ICPPConstructor)ctor).isImplicit();
    }

    public static ICPPEvaluation getVariableValue(ICPPVariable variable, ActivationRecord record) {
        Set<ICPPVariable> recursionProtectionSet = fInitialValueInProgress.get();
        if (!recursionProtectionSet.add(variable)) {
            return EvalFixed.INCOMPLETE;
        }
        try {
            IType type = variable.getType();
            IType nestedType = SemanticUtil.getNestedType(type, 13);
            IValue initialValue = variable.getInitialValue();
            ICPPEvaluation valueEval = null;
            if (initialValue != null && initialValue.getEvaluation() != null || initialValue == null && nestedType instanceof ICPPClassType) {
                ICPPEvaluation initializerEval;
                ICPPEvaluation iCPPEvaluation = initializerEval = initialValue == null ? null : initialValue.getEvaluation();
                if (initializerEval == EvalFixed.INCOMPLETE) {
                    return null;
                }
                ExecDeclarator declaratorExec = new ExecDeclarator(variable, initializerEval);
                ICPPEvaluation.ConstexprEvaluationContext context = new ICPPEvaluation.ConstexprEvaluationContext();
                if (declaratorExec.executeForFunctionCall(record, context) != ExecIncomplete.INSTANCE) {
                    valueEval = record.getVariable(declaratorExec.getDeclaredBinding());
                }
            } else if (initialValue != null) {
                valueEval = new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, initialValue);
            }
            if (valueEval != null && (valueEval == EvalFixed.INCOMPLETE || valueEval.getValue() == IntegralValue.UNKNOWN)) {
                return null;
            }
            EvalFixed evalFixed = valueEval;
            return evalFixed;
        }
        finally {
            recursionProtectionSet.remove(variable);
        }
    }

    public static boolean isDefaultConstructor(ICPPConstructor constructor) {
        return constructor.getRequiredArgumentCount() == 0;
    }

    public static boolean evaluateNoexceptSpecifier(ICPPEvaluation noexceptSpecifier) {
        IntegralValue v;
        if (noexceptSpecifier != null && noexceptSpecifier.getValue() instanceof IntegralValue && (v = (IntegralValue)noexceptSpecifier.getValue()).numberValue() != null) {
            return v.numberValue().longValue() == 1L;
        }
        return false;
    }

    public static class Pair<T1, T2> {
        private final T1 first;
        private final T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }

        public T1 getFirst() {
            return this.first;
        }

        public T2 getSecond() {
            return this.second;
        }
    }
}

