/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ConnectionType;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayCommand;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayResponse;

public class ConnectResponse
implements IRelayResponse,
IRelayCommand {
    public static final int SIZE = 20;
    private final long fViewerSessionId;
    private final int fMajor;
    private final int fMinor;
    private final ConnectionType fType;

    public ConnectResponse(DataInputStream inStream) throws IOException {
        byte[] data = new byte[20];
        inStream.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fViewerSessionId = bb.getLong();
        this.fMajor = bb.getInt();
        this.fMinor = bb.getInt();
        bb.getInt();
        this.fType = ConnectionType.VIEWER_CLIENT_COMMAND;
    }

    public ConnectResponse(long sessionID, int major, int minor, ConnectionType connection) {
        this.fViewerSessionId = sessionID;
        this.fMajor = major;
        this.fMinor = minor;
        this.fType = connection;
    }

    public int getMajor() {
        return this.fMajor;
    }

    public int getMinor() {
        return this.fMinor;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[20];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putLong(this.fViewerSessionId);
        bb.putInt(this.fMajor);
        bb.putInt(this.fMinor);
        bb.putInt(this.fType.getCommand());
        return data;
    }
}

