/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;
import org.eclipse.wst.sse.core.internal.encoding.util.Assert;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.exceptions.CharConversionErrorWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;

public class CodedStreamCreator
extends CodedIO {
    private static final int INITIAL_BUFFER_SIZE = 16384;
    private static final String PROGRAM_ERROR__FAILED_TO_FIND_ANY_CHARSET_ANYWHERE_ = "Program error: failed to find any charset anywhere!";
    private static final String UTF_16BE_CHARSET_NAME = "UTF-16BE";
    private static final String UTF_16LE_CHARSET_NAME = "UTF-16LE";
    private static final String UTF_8_CHARSET_NAME = "UTF-8";
    private boolean fClientSuppliedReader;
    private EncodingMemento fCurrentEncodingMemento;
    private EncodingMemento fEncodingMemento;
    private String fFilename;
    private boolean fHasBeenAnalyzed;
    private IFile fIFile;
    private EncodingMemento fPreviousEncodingMemento;
    private Reader fReader;
    private Reader fResettableReader;
    private byte[] UTF16BEBOM = new byte[]{-2, -1};
    private byte[] UTF16LEBOM = new byte[]{-1, -2};
    private byte[] UTF3BYTEBOM = new byte[]{-17, -69, -65};

    public CodedStreamCreator() {
    }

    public CodedStreamCreator(String filename, char[] characterArray) {
        this.fFilename = filename;
        this.fReader = new CharArrayReader(characterArray);
    }

    public CodedStreamCreator(String filename, Reader reader) {
        this.fFilename = filename;
        this.fReader = reader;
    }

    public CodedStreamCreator(String filename, String textString) {
        this.fFilename = filename;
        this.fReader = new StringReader(textString);
    }

    private void analyze() throws CoreException, IOException {
        Reader resettableReader = this.getResettableReader();
        try {
            if (this.fCurrentEncodingMemento == null) {
                resettableReader.reset();
                this.fCurrentEncodingMemento = this.checkForEncodingInContents();
            }
            if (this.fCurrentEncodingMemento == null || this.fCurrentEncodingMemento.getDetectedCharsetName() == null) {
                resettableReader.reset();
                this.fCurrentEncodingMemento = this.getEncodingMementoFromResourceAndPreference();
            }
            if (this.fEncodingMemento == null) {
                this.handleNotProvidedFromContentCase();
            }
            this.fHasBeenAnalyzed = true;
        }
        finally {
            if (resettableReader != null) {
                resettableReader.reset();
            }
        }
    }

    private void checkConversion(EncodingMemento memento, EncodingRule encodingRule) throws IOException {
        String javaEncoding = memento.getJavaCharsetName();
        String detectedEncoding = memento.getDetectedCharsetName();
        Charset charset = Charset.forName(javaEncoding);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        Reader reader = this.getResettableReader();
        reader.reset();
        int currentChar = reader.read();
        int currentPos = 1;
        try {
            while (currentChar != -1) {
                try {
                    boolean canConvert = charsetEncoder.canEncode((char)currentChar);
                    if (!canConvert) {
                        if (encodingRule == EncodingRule.IGNORE_CONVERSION_ERROR) {
                            Logger.log(4, "Encoding Conversion Error during save");
                        } else {
                            throw new MalformedOutputExceptionWithDetail(javaEncoding, detectedEncoding, currentPos);
                        }
                    }
                    currentChar = reader.read();
                    ++currentPos;
                }
                catch (NullPointerException nullPointerException) {
                    throw new CharConversionErrorWithDetail(javaEncoding);
                }
            }
            throw new CharConversionErrorWithDetail(javaEncoding);
        }
        catch (Throwable throwable) {
            reader.reset();
            throw throwable;
        }
    }

    private EncodingMemento checkForEncodingInContents() throws CoreException, IOException {
        EncodingMemento result = null;
        if (this.fEncodingMemento != null) {
            result = this.fEncodingMemento;
        } else if (this.fClientSuppliedReader) {
            this.fReader.reset();
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            try {
                IContentDescription contentDescription = contentTypeManager.getDescriptionFor(this.fReader, this.fFilename, IContentDescription.ALL);
                this.fEncodingMemento = contentDescription != null ? this.createMemento(contentDescription) : CodedIO.createEncodingMemento(UTF_8_CHARSET_NAME);
            }
            catch (NullPointerException nullPointerException) {
                this.fEncodingMemento = CodedIO.createEncodingMemento(UTF_8_CHARSET_NAME);
            }
            result = this.fEncodingMemento;
        } else {
            throw new IllegalStateException("unexpected state: encodingMemento was null but no input stream supplied");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dump(OutputStream outputStream, EncodingRule encodingRule, boolean use3ByteBOMifUTF8) throws CoreException, IOException {
        this.getCurrentEncodingMemento();
        String javaEncodingName = null;
        if (encodingRule == EncodingRule.CONTENT_BASED) {
            if (!this.fCurrentEncodingMemento.isValid()) throw new UnsupportedCharsetExceptionWithDetail(this.fCurrentEncodingMemento);
            javaEncodingName = this.fCurrentEncodingMemento.getJavaCharsetName();
        } else if (encodingRule == EncodingRule.IGNORE_CONVERSION_ERROR) {
            javaEncodingName = this.fCurrentEncodingMemento.getJavaCharsetName();
        } else if (encodingRule == EncodingRule.FORCE_DEFAULT) {
            javaEncodingName = this.fCurrentEncodingMemento.getAppropriateDefault();
        }
        if (javaEncodingName != null) {
            if (javaEncodingName.equals(UTF_8_CHARSET_NAME) && use3ByteBOMifUTF8 || javaEncodingName.equals(UTF_8_CHARSET_NAME) && this.fCurrentEncodingMemento.isUTF83ByteBOMUsed()) {
                outputStream.write(this.UTF3BYTEBOM);
            } else if (javaEncodingName.equals(UTF_16LE_CHARSET_NAME)) {
                outputStream.write(this.UTF16LEBOM);
            } else if (javaEncodingName.equals(UTF_16BE_CHARSET_NAME)) {
                outputStream.write(this.UTF16BEBOM);
            }
        }
        Reader reader = this.getResettableReader();
        reader.reset();
        Charset charset = null;
        javaEncodingName = CodedIO.getAppropriateJavaCharset(javaEncodingName);
        charset = javaEncodingName == null ? Charset.forName(this.fCurrentEncodingMemento.getDetectedCharsetName()) : Charset.forName(javaEncodingName);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        if (encodingRule != EncodingRule.IGNORE_CONVERSION_ERROR) {
            charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        } else {
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charsetEncoder);
        char[] charbuf = new char[8192];
        int nRead = 0;
        try {
            try {
                while (nRead != -1) {
                    nRead = reader.read(charbuf, 0, 8192);
                    if (nRead <= 0) continue;
                    outputStreamWriter.flush();
                    outputStreamWriter.write(charbuf, 0, nRead);
                }
                return;
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                this.checkConversion(this.fCurrentEncodingMemento, encodingRule);
                outputStreamWriter.flush();
            }
            return;
        }
        finally {
            outputStreamWriter.flush();
        }
    }

    private boolean get3ByteBOMPreference() {
        return SSECorePlugin.getDefault().getPluginPreferences().getBoolean("Use3ByteBOMWithUTF8");
    }

    public ByteArrayOutputStream getCodedByteArrayOutputStream() throws CoreException, IOException {
        return this.getCodedByteArrayOutputStream(EncodingRule.CONTENT_BASED);
    }

    public ByteArrayOutputStream getCodedByteArrayOutputStream(EncodingRule encodingRule) throws CoreException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        this.dump(byteArrayOutputStream, encodingRule, this.get3ByteBOMPreference());
        return byteArrayOutputStream;
    }

    public EncodingMemento getCurrentEncodingMemento() throws CoreException, IOException {
        if (!this.fHasBeenAnalyzed) {
            this.analyze();
        }
        Assert.isNotNull(this.fCurrentEncodingMemento, "illegal post condition state");
        if (this.fPreviousEncodingMemento != null) {
            this.fCurrentEncodingMemento.setUTF83ByteBOMUsed(this.fPreviousEncodingMemento.isUTF83ByteBOMUsed());
        }
        return this.fCurrentEncodingMemento;
    }

    private EncodingMemento getEncodingMementoFromResourceAndPreference() throws IOException, CoreException {
        EncodingMemento encodingMemento = this.fEncodingMemento;
        if (this.fIFile != null) {
            String charset = this.fIFile.getCharset();
            encodingMemento = CodedIO.createEncodingMemento(charset);
        }
        return encodingMemento;
    }

    private Reader getResettableReader() {
        if (this.fResettableReader == null) {
            if (this.fReader.markSupported()) {
                this.fResettableReader = this.fReader;
            } else {
                this.fResettableReader = new BufferedReader(this.fReader);
                try {
                    this.fResettableReader.mark(8192);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
        return this.fResettableReader;
    }

    protected void handleNotProvidedFromContentCase() {
        String specDefault = null;
        String charset = NonContentBasedEncodingRules.useDefaultNameRules(specDefault);
        Assert.isNotNull(charset, PROGRAM_ERROR__FAILED_TO_FIND_ANY_CHARSET_ANYWHERE_);
        this.fCurrentEncodingMemento = CodedIO.createEncodingMemento(charset);
    }

    void migrateContentPropertiesEncoding(String encoding) throws CoreException {
        if (this.fIFile != null) {
            this.fIFile.setCharset(encoding, null);
        }
        final IFile file = this.fIFile;
        final String charset = encoding;
        Job migrater = new Job(SSECoreMessages.Migrate_Charset){

            protected IStatus run(IProgressMonitor monitor) {
                if (file != null) {
                    try {
                        file.setCharset(charset, null);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        migrater.setSystem(true);
        migrater.schedule();
    }

    private void resetAll() {
        this.fFilename = null;
        this.fReader = null;
        this.fPreviousEncodingMemento = null;
        this.fCurrentEncodingMemento = null;
        this.fHasBeenAnalyzed = false;
        this.fClientSuppliedReader = false;
    }

    public void set(IFile file, Reader reader) {
        this.fIFile = file;
        this.set(file.getName(), reader);
    }

    public void set(String filename, char[] characterArray) {
        this.resetAll();
        this.fFilename = filename;
        this.fReader = new CharArrayReader(characterArray);
    }

    public void set(String filename, Reader reader) {
        this.resetAll();
        this.fFilename = filename;
        this.fReader = reader;
        this.fClientSuppliedReader = true;
    }

    public void set(String filename, String textString) {
        this.set(filename, (Reader)new StringReader(textString));
    }

    public void setPreviousEncodingMemento(EncodingMemento previousEncodingMemento) {
        this.fPreviousEncodingMemento = previousEncodingMemento;
    }
}

