/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.osgi.framework.Bundle;

public final class CommonCharsetNames {
    private static Properties defaultIANAmappings = null;
    private static List<String> encodings = null;
    private static Map<String, String> supportedEncodingDisplayNames = null;
    private static Map<String, String> prefNames = null;

    public static String[] getCommonCharsetNames() {
        String[] enc = new String[CommonCharsetNames.getEncodings().size()];
        CommonCharsetNames.getEncodings().toArray(enc);
        return enc;
    }

    private static Properties getDefaultIANAMappings() {
        if (defaultIANAmappings == null) {
            defaultIANAmappings = new Properties();
            Bundle keyBundle = Platform.getBundle((String)"org.eclipse.wst.sse.core");
            Path keyPath = new Path("config/defaultIANA.properties");
            URL location = Platform.find((Bundle)keyBundle, (IPath)keyPath);
            InputStream propertiesInputStream = null;
            try {
                propertiesInputStream = location.openStream();
                defaultIANAmappings.load(propertiesInputStream);
            }
            catch (IOException iOException) {}
        }
        return defaultIANAmappings;
    }

    public static String getDisplayString(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        String result = CommonCharsetNames.getSupportedEncodingDisplayNames().get(charsetName);
        if (result == null) {
            try {
                Charset charset = Charset.forName(charsetName);
                result = charset.displayName();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return result;
    }

    public static String getPreferenceName(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        String result = CommonCharsetNames.getPreferenceNames().get(charsetName);
        if (result == null) {
            return charsetName;
        }
        return result;
    }

    private static List<String> getEncodings() {
        if (encodings == null) {
            CommonCharsetNames.initHashTables();
        }
        return encodings;
    }

    public static String getIanaPreferredCharsetName(String charsetName) {
        String preferredName = charsetName;
        try {
            Charset charset = Charset.forName(charsetName);
            if (charset.name() != null) {
                preferredName = charset.name();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {}
        return preferredName;
    }

    public static String getPreferredDefaultIanaName(String charsetName, String defaultIanaName) {
        String preferredName = defaultIanaName;
        String guessedName = charsetName;
        try {
            guessedName = CodedIO.getAppropriateJavaCharset(charsetName);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {}
        preferredName = CommonCharsetNames.getEncodings().contains(guessedName) ? guessedName : CommonCharsetNames.getDefaultIANAMappings().getProperty(guessedName, preferredName);
        return preferredName;
    }

    private static Map<String, String> getSupportedEncodingDisplayNames() {
        if (supportedEncodingDisplayNames == null) {
            CommonCharsetNames.initHashTables();
        }
        return supportedEncodingDisplayNames;
    }

    private static Map<String, String> getPreferenceNames() {
        if (prefNames == null) {
            CommonCharsetNames.initHashTables();
        }
        return prefNames;
    }

    private static void initHashTables() {
        block22: {
            if (supportedEncodingDisplayNames == null) {
                supportedEncodingDisplayNames = new HashMap<String, String>();
                encodings = new ArrayList<String>();
                prefNames = new HashMap<String, String>();
                FallbackPropertyResourceBundle bundle = null;
                InputStream bundleStream = null;
                try {
                    try {
                        bundleStream = FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.wst.sse.core"), (IPath)Path.fromOSString((String)"$nl$/config/charset.properties"), (boolean)true);
                        bundle = new FallbackPropertyResourceBundle(bundleStream, Path.fromOSString((String)"/config/charset.properties"));
                        String totalNumString = bundle.getProperty("totalnumber");
                        int totalNum = 0;
                        if (totalNumString.length() != 0) {
                            try {
                                totalNum = Integer.valueOf(totalNumString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                totalNum = 0;
                            }
                        }
                        int i = 0;
                        while (i < totalNum) {
                            String iana = bundle.getProperty("codeset." + i + ".iana");
                            String displayName = bundle.getProperty("codeset." + i + ".label");
                            String prefName = null;
                            try {
                                prefName = bundle.getProperty("codeset." + i + ".prefName");
                            }
                            catch (MissingResourceException missingResourceException) {}
                            encodings.add(iana);
                            supportedEncodingDisplayNames.put(iana, displayName);
                            if (prefName != null) {
                                prefNames.put(prefName, iana);
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        Logger.logException("invalid install or configuration", e);
                        try {
                            if (bundleStream != null) {
                                bundleStream.close();
                            }
                            break block22;
                        }
                        catch (IOException iOException) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (bundleStream != null) {
                            bundleStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (bundleStream != null) {
                        bundleStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        String test = "Cp1252";
        String result = CommonCharsetNames.getIanaPreferredCharsetName(test);
        System.out.println(String.valueOf(test) + " --> " + result);
        test = "MS932";
        result = CommonCharsetNames.getIanaPreferredCharsetName(test);
        System.out.println(String.valueOf(test) + " --> " + result);
    }

    public CommonCharsetNames() {
        CommonCharsetNames.initHashTables();
    }

    static class FallbackPropertyResourceBundle
    extends PropertyResourceBundle {
        private PropertyResourceBundle fallback = null;
        private IPath fallbackPath;

        public FallbackPropertyResourceBundle(InputStream stream, IPath fallbackPath) throws IOException {
            super(stream);
            this.fallbackPath = fallbackPath;
        }

        public String getProperty(String key) {
            String property;
            block21: {
                property = null;
                try {
                    property = this.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    block20: {
                        Bundle bundle;
                        if (this.fallback == null && this.fallbackPath != null && (bundle = Platform.getBundle((String)"org.eclipse.wst.sse.core")) != null) {
                            InputStream stream = null;
                            try {
                                try {
                                    stream = FileLocator.openStream((Bundle)bundle, (IPath)this.fallbackPath, (boolean)true);
                                    if (stream != null) {
                                        this.fallback = new PropertyResourceBundle(stream);
                                    }
                                }
                                catch (IOException iOException) {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (IOException iOException2) {}
                                    }
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (this.fallback == null) break block21;
                    try {
                        property = this.fallback.getString(key);
                    }
                    catch (MissingResourceException missingResourceException2) {}
                }
            }
            return property;
        }
    }
}

