/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.util.Assert;

public abstract class ContentTypeEncodingPreferences {
    public static final String WORKBENCH_DEFAULT = "WORKBENCH_DEFAULT";

    private static final String getJavaPlatformDefaultEncoding() {
        String enc = System.getProperty("file.encoding");
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    public static final String getPreferredNewLineDelimiter(String contentTypeId) {
        String result = null;
        String newLineCode = null;
        newLineCode = ContentBasedPreferenceGateway.getPreferencesString(contentTypeId, "endOfLineCode");
        if (newLineCode == null) {
            result = null;
        } else if (newLineCode.equals("EOL_Mac")) {
            result = "\r";
        } else if (newLineCode.equals("EOL_Unix")) {
            result = "\n";
        } else if (newLineCode.equals("EOL_Windows")) {
            result = "\r\n";
        }
        return result;
    }

    public static final String getUserPreferredCharsetName(String contentTypeId) {
        String prefEncoding;
        String encoding = prefEncoding = ContentBasedPreferenceGateway.getPreferencesString(contentTypeId, "outputCodeset");
        if (prefEncoding == null || prefEncoding.trim().length() == 0 || prefEncoding.equals(WORKBENCH_DEFAULT)) {
            encoding = ContentTypeEncodingPreferences.getWorkbenchPreferredCharsetName();
        }
        return encoding;
    }

    public static final String getUserSpecifiedDefaultEncodingPreference() {
        String ContentTypeID_HTML = "org.eclipse.wst.html.core.htmlsource";
        return ContentTypeEncodingPreferences.getUserSpecifiedDefaultEncodingPreference(ContentTypeID_HTML);
    }

    public static final String getUserSpecifiedDefaultEncodingPreference(String contentTypeID) {
        String enc = null;
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
        if (contentType != null) {
            enc = contentType.getDefaultCharset();
        }
        if (enc == null || enc.trim().length() == 0) {
            enc = ContentBasedPreferenceGateway.getPreferencesString(contentTypeID, "inputCodeset");
        }
        if (enc == null || enc.trim().length() == 0) {
            enc = ContentTypeEncodingPreferences.getWorkbenchSpecifiedDefaultEncoding();
        }
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    private static final String getWorkbenchPreferredCharsetName() {
        String charset = ResourcesPlugin.getEncoding();
        charset = CommonCharsetNames.getIanaPreferredCharsetName(charset);
        return charset;
    }

    private static final String getWorkbenchSpecifiedDefaultEncoding() {
        ResourcesPlugin resourcePlugin = ResourcesPlugin.getPlugin();
        String enc = resourcePlugin.getPluginPreferences().getString("encoding");
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    public static final String useDefaultNameRules(IResourceCharsetDetector encodingProvider) {
        String result = null;
        String enc = null;
        enc = encodingProvider.getSpecDefaultEncoding();
        if (enc != null) {
            result = enc;
        } else {
            enc = ContentTypeEncodingPreferences.getUserSpecifiedDefaultEncodingPreference();
            if (enc != null && enc.trim().length() > 0) {
                result = enc;
            } else {
                if ((enc == null || enc.trim().length() == 0) && (enc = ContentTypeEncodingPreferences.getWorkbenchSpecifiedDefaultEncoding()) != null) {
                    result = enc;
                }
                if ((enc == null || enc.trim().length() == 0) && (enc = ContentTypeEncodingPreferences.getJavaPlatformDefaultEncoding()) != null) {
                    result = enc;
                }
            }
        }
        Assert.isNotNull(enc, "post condition invalid");
        result = CodedIO.checkMappingOverrides(enc);
        return result;
    }
}

