/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

public class StringDelimitedTokenizer {
    private final String str;
    private final String delimiter;
    private final int delimiterLength;
    private int currentPosition = 0;
    private final int maxPosition;

    public StringDelimitedTokenizer(String str, String delim) {
        this.str = str;
        this.delimiter = delim;
        this.maxPosition = this.str.length();
        this.delimiterLength = this.delimiter.length();
    }

    public int countTokens() {
        int count = 0;
        int startPosition = 0;
        while (startPosition < this.maxPosition && startPosition != -1) {
            if ((startPosition = this.str.indexOf(this.delimiter, startPosition)) != -1) {
                startPosition += this.delimiterLength;
            }
            ++count;
        }
        return count;
    }

    public boolean endsWithDelimiter() {
        return this.str.endsWith(this.delimiter);
    }

    public boolean hasMoreTokens() {
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        int position = this.str.indexOf(this.delimiter, this.currentPosition);
        String token = null;
        if (position == -1) {
            token = this.str.substring(this.currentPosition);
            this.currentPosition = this.maxPosition;
        } else {
            token = this.str.substring(this.currentPosition, position);
            this.currentPosition = position + this.delimiterLength;
        }
        return token;
    }
}

