/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.criticalpath;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathAlgorithm;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;

public abstract class AbstractCriticalPathAlgorithm
implements ICriticalPathAlgorithm {
    private final ITmfGraph fGraph;

    public AbstractCriticalPathAlgorithm(ITmfGraph graph) {
        this.fGraph = graph;
    }

    public ITmfGraph getGraph() {
        return this.fGraph;
    }

    protected ITmfVertex copyLink(ITmfGraph criticalPath, ITmfGraph graph, ITmfVertex anchor, ITmfVertex from, ITmfVertex to, long ts, @Nullable ITmfEdgeContextState contextState, @Nullable String string) {
        IGraphWorker parentTo = graph.getParentOf(to);
        if (parentTo == null) {
            throw new NullPointerException();
        }
        ITmfVertex tmp = criticalPath.createVertex(parentTo, ts);
        if (tmp.equals(anchor)) {
            return anchor;
        }
        if (contextState == null) {
            criticalPath.edge(anchor, tmp);
        } else if (string == null) {
            criticalPath.edge(anchor, tmp, contextState);
        } else {
            criticalPath.edge(anchor, tmp, contextState, string);
        }
        return tmp;
    }

    public @Nullable ITmfVertex findIncoming(ITmfVertex vertex, ITmfGraph.EdgeDirection dir) {
        ITmfVertex currentVertex = vertex;
        while (true) {
            ITmfEdge incoming;
            if ((incoming = this.fGraph.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE)) != null) {
                return currentVertex;
            }
            ITmfEdge edge = this.fGraph.getEdgeFrom(vertex, dir);
            if (edge == null) break;
            currentVertex = this.getNeighborFromEdge(edge, dir);
        }
        return null;
    }

    protected ITmfVertex getNeighborFromEdge(ITmfEdge edge, ITmfGraph.EdgeDirection dir) {
        switch (dir) {
            case OUTGOING_VERTICAL_EDGE: 
            case OUTGOING_HORIZONTAL_EDGE: {
                return edge.getVertexTo();
            }
            case INCOMING_VERTICAL_EDGE: 
            case INCOMING_HORIZONTAL_EDGE: {
                return edge.getVertexFrom();
            }
        }
        throw new IllegalStateException("Unknown direction: " + String.valueOf((Object)dir));
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }
}

