/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.piecharts;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.AbstractSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;

public class CircularSeriesSettings
extends AbstractSeriesSettings
implements ICircularSeriesSettings {
    private Color sliceColor = Display.getDefault().getSystemColor(2);
    private Color borderColor = Display.getDefault().getSystemColor(15);
    private int borderWidth = 1;
    private LineStyle borderStyle = LineStyle.SOLID;
    private ISeries.SeriesType seriesType = ISeries.SeriesType.PIE;
    private boolean redrawOnClick = true;
    private boolean fillEntireSpace = false;
    private ICircularSeriesSettings seriesSettingsHighlight = null;

    @Override
    public Color getSliceColor() {
        return this.sliceColor;
    }

    @Override
    public void setSliceColor(Color color) {
        this.sliceColor = color;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public LineStyle getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public void setBorderStyle(LineStyle borderStyle) {
        this.borderStyle = borderStyle;
    }

    @Override
    public void setSeriesType(ISeries.SeriesType type) {
        this.seriesType = type;
    }

    @Override
    public ISeries.SeriesType getSeriesType() {
        return this.seriesType;
    }

    @Override
    public void setRedrawOnClick(boolean redraw) {
        this.redrawOnClick = redraw;
    }

    @Override
    public boolean isRedrawOnClick() {
        return this.redrawOnClick;
    }

    @Override
    public void setFillEntireSpace(boolean fillEntireSpace) {
        this.fillEntireSpace = fillEntireSpace;
    }

    @Override
    public boolean isEntireSpaceFilled() {
        return this.fillEntireSpace;
    }

    @Override
    public ISeriesSettings getSeriesSettingsHighlight() {
        if (this.seriesSettingsHighlight == null) {
            try {
                this.seriesSettingsHighlight = (ICircularSeriesSettings)this.clone();
                this.seriesSettingsHighlight.setHighlight(true);
            }
            catch (CloneNotSupportedException e) {
                this.seriesSettingsHighlight = new CircularSeriesSettings();
            }
        }
        return this.seriesSettingsHighlight;
    }

    @Override
    public ISeriesSettings makeDeepCopy() {
        CircularSeriesSettings circularSeriesSettings = new CircularSeriesSettings();
        this.transfer(circularSeriesSettings);
        return circularSeriesSettings;
    }

    @Override
    public boolean transfer(ISeriesSettings seriesSettingsSink) {
        boolean success = false;
        if (seriesSettingsSink instanceof ICircularSeriesSettings) {
            CircularSeriesSettings source = this;
            ICircularSeriesSettings sink = (ICircularSeriesSettings)seriesSettingsSink;
            sink.setDescription(source.getDescription());
            sink.setVisible(source.isVisible());
            sink.setVisibleInLegend(source.isVisibleInLegend());
            sink.setSliceColor(source.getSliceColor());
            sink.setBorderColor(source.getBorderColor());
            sink.setBorderWidth(source.getBorderWidth());
            sink.setBorderStyle(source.getBorderStyle());
            sink.setSeriesType(source.getSeriesType());
            sink.setRedrawOnClick(source.isRedrawOnClick());
            sink.setFillEntireSpace(source.isEntireSpaceFilled());
            sink.setHighlight(source.isHighlight());
            success = true;
        }
        return success;
    }

    protected Object clone() throws CloneNotSupportedException {
        CircularSeriesSettings circularSeriesSettings = new CircularSeriesSettings();
        this.transfer(circularSeriesSettings);
        return circularSeriesSettings;
    }
}

