/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.PropertiesResources;

public abstract class AbstractPage
extends PreferencePage {
    protected InteractiveChart chart;
    protected PropertiesResources resources;

    public AbstractPage(InteractiveChart chart, PropertiesResources resources, String title) {
        this.chart = chart;
        this.resources = resources;
        this.setTitle(title);
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.apply();
            this.chart.redraw();
        }
        return true;
    }

    public abstract void apply();

    protected Group createGroupControl(Composite parent, String text, boolean equal) {
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayout((Layout)new GridLayout(2, equal));
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    protected Label createLabelControl(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected ColorSelector createColorButtonControl(Composite parent) {
        return new ColorSelector(parent);
    }

    protected Button createCheckBoxControl(Composite parent, String label) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button button = new Button(composite, 32);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 1;
        button.setLayoutData((Object)gridData1);
        this.createLabelControl(composite, label);
        return button;
    }

    protected Text createTextControl(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Combo createComboControl(Composite parent, String[] items) {
        Combo combo = new Combo(parent, 2052);
        combo.setItems(items);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    protected Spinner createSpinnerControl(Composite parent, int min, int max) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        spinner.setLayoutData((Object)gridData);
        return spinner;
    }
}

