/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IConsoleParser;

public class ConsoleOutputSniffer {
    private int nOpens = 0;
    private OutputStream consoleOutputStream;
    private OutputStream consoleErrorStream;
    private IConsoleParser[] parsers;

    public ConsoleOutputSniffer(IConsoleParser[] parsers) {
        this.parsers = parsers;
    }

    public ConsoleOutputSniffer(OutputStream outputStream, OutputStream errorStream, IConsoleParser[] parsers) {
        this(parsers);
        this.consoleOutputStream = outputStream;
        this.consoleErrorStream = errorStream;
    }

    public OutputStream getOutputStream() {
        this.incNOpens();
        return new ConsoleOutputStream(this.consoleOutputStream);
    }

    public OutputStream getErrorStream() {
        this.incNOpens();
        return new ConsoleOutputStream(this.consoleErrorStream);
    }

    private synchronized void incNOpens() {
        ++this.nOpens;
    }

    public synchronized void closeConsoleOutputStream() throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            int i = 0;
            while (i < this.parsers.length) {
                try {
                    this.parsers[i].shutdown();
                }
                catch (Throwable e) {
                    CCorePlugin.log(e);
                }
                ++i;
            }
        }
    }

    private synchronized void processLine(String line) {
        IConsoleParser[] iConsoleParserArray = this.parsers;
        int n = this.parsers.length;
        int n2 = 0;
        while (n2 < n) {
            IConsoleParser parser = iConsoleParserArray[n2];
            try {
                parser.processLine(line);
            }
            catch (Throwable e) {
                CCorePlugin.log(e);
            }
            ++n2;
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private StringBuilder currentLine = new StringBuilder();
        private OutputStream outputStream = null;

        public ConsoleOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.currentLine.append((char)b);
            this.checkLine(false);
            if (this.outputStream != null) {
                this.outputStream.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off != 0 || len < 0 || len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.currentLine.append(new String(b, 0, len));
            this.checkLine(false);
            if (this.outputStream != null) {
                this.outputStream.write(b, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            this.checkLine(true);
            ConsoleOutputSniffer.this.closeConsoleOutputStream();
        }

        @Override
        public void flush() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        private void checkLine(boolean flush) {
            if (this.currentLine.length() == 0) {
                return;
            }
            String buffer = this.currentLine.toString();
            int i = 0;
            while ((i = buffer.indexOf(10)) != -1) {
                int eol = i;
                if (i > 0 && buffer.charAt(i - 1) == '\r') {
                    eol = i - 1;
                }
                String line = buffer.substring(0, eol);
                ConsoleOutputSniffer.this.processLine(line);
                buffer = buffer.substring(i + 1);
            }
            this.currentLine.setLength(0);
            if (flush) {
                if (buffer.length() > 0) {
                    ConsoleOutputSniffer.this.processLine(buffer);
                }
            } else {
                this.currentLine.append(buffer);
            }
        }
    }
}

