/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.stabs;

import org.eclipse.cdt.core.CCorePlugin;

public class StringField {
    String name;
    char symbolDescriptor;
    String typeInformation;

    public StringField(String s) {
        this.parseStringField(s.toCharArray());
    }

    public String getName() {
        return this.name;
    }

    public char getSymbolDescriptor() {
        return this.symbolDescriptor;
    }

    public String getTypeInformation() {
        return this.typeInformation;
    }

    void parseStringField(char[] array) {
        int index = 0;
        char prev = '\u0000';
        while (index < array.length) {
            char c = array[index];
            if (c == ':' && prev != ':') break;
            prev = c;
            ++index;
        }
        this.name = index < array.length ? new String(array, 0, index) : new String(array);
        if (this.name.length() > 1 && this.name.charAt(0) == '$') {
            switch (this.name.charAt(1)) {
                case 't': {
                    this.name = "this";
                    break;
                }
                case 'v': {
                    break;
                }
                case 'e': {
                    this.name = "eh_throw";
                    break;
                }
                case '_': {
                    break;
                }
                case 'X': {
                    break;
                }
                default: {
                    this.name = CCorePlugin.getResourceString("Util.unknownName");
                }
            }
        }
        if (index < array.length && Character.isLetter(array[++index])) {
            this.symbolDescriptor = array[index];
            ++index;
        }
        this.typeInformation = index < array.length ? new String(array, index, array.length - index) : "";
    }
}

